/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
// ドロップダウンメニュークラスへの対応
jQuery(function($){
    const mw = window.matchMedia('(max-width: 1024px)');
    let cistr = 'menu-click-icon';
    let clickIcon = '<span class="'+cistr+'"></span>';
    let target = 'ul.mdd li:has(ul)';//モバイル時のみ
    let target2 = 'ul.dd li:has(ul)';//常時
    let lastTime = 0;

    function handleMediaChange(e) {
        if (e.matches) {
            // 画面幅1024px以下
            ddAdd();
        } else {
            // 画面幅1025px以上
            ddRemove();
        }
    }
    function ddAdd() {
        $(target+','+target2).each(function(){
            $(this).append(clickIcon);
            $(this).children('ul').hide();
        });
    }
    function ddRemove() {
        $(target+' .'+cistr).each(function(){
            $(this).remove();
        });
        $(target+' > ul').each(function(){
            $(this).show();
        });
    }
    $(target+' > ul,'+target2+' > ul').each(function(){
        if($(this).parent('li').hasClass('submenu-open')) {}else{
            $(this).hide();
        }
        $(this).parent('li').on('click','.menu-click-icon',function(){
            const nowTime = Date.now();
            if(nowTime - lastTime < 500) return;
            lastTime = nowTime;
            $(this).parent('li').toggleClass('submenu-open');
            if($(this).parent('li').hasClass('submenu-open')) {
                $(this).parent('li').children('ul').slideDown(300);
            }else{
                $(this).parent('li').children('ul').slideUp(300);
            }
            
        });
    });
    ddAdd();
    handleMediaChange(mw);
    mw.addEventListener('change', handleMediaChange);

    let classes = ['current_page_ancestor', 'current_page_parent', 'current_page_item'];
    $(target+' > ul,'+target2+' > ul').each(function(){
        let cflug = classes.some(c => $(this).parent('li').hasClass(c));
        if(cflug) {
            $(this).parent('li').toggleClass('submenu-open');
            $(this).parent('li').children('ul').slideDown(300);
        }
    });
});

//下方へのスクロール中はヘッダー収納
jQuery(function($){
    let lastScrollTop = 0;
    let scrollTimer = null;
    let $header = $("#header");

    $(window).on('scroll', function() {
        let currentScrollTop = $(this).scrollTop();

        // 下方向 or 上方向を判定
        if (currentScrollTop > lastScrollTop) {
            if(!$header.hasClass('hide')) {
                $header.addClass('hide');
            }
        } else if (currentScrollTop < lastScrollTop) {
            if($header.hasClass('hide')) {
                $header.removeClass('hide');
            }
        }

        lastScrollTop = currentScrollTop;

        // スクロールが止まったか判定するタイマー
        if (scrollTimer !== null) {
            clearTimeout(scrollTimer);
        }
        scrollTimer = setTimeout(function() {
            if($header.hasClass('hide')) {
                $header.removeClass('hide');
            }
        }, 300);
    });
});