/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
jQuery(document).ready(function ($) {
    const allowed = CEAllowedWidgetsData.allowed;
    const classMap = CEAllowedWidgetsData.widgetClassMap;
    $('.widgets-holder-wrap .widget').each(function () {
        const $widget = $(this);
        const widgetId = $widget.attr('id');
        if (!widgetId) return;
        const baseIdb1 = widgetId.split(/_(.+)/)[1];
        const lastIndex = baseIdb1.lastIndexOf('-');
        const baseId = baseIdb1.slice(0, lastIndex);
        const widgetClass = classMap[baseId];
        if (widgetClass && allowed.indexOf(widgetClass) === -1) {
            $widget.hide();
        }
    });
});
