/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
jQuery(function($){
    function openMediaPicker(button) {
        var frame = wp.media({
            title: '画像',
            button: { text: '画像を選択' },
            multiple: false
        });
        frame.on('select', function(){
            var attachment = frame.state().get('selection').first().toJSON();
            var container = button.closest('.ce-img-selecter');
            container.find('.ce-image-preview').attr('src', attachment.url).show();
            button.siblings('.ce-img').val(attachment.url).trigger('change');
        });
        frame.open();
    }
    function deleteMedia(button) {
        var container = button.closest('.ce-img-selecter');
        container.find('.ce-image-preview').attr('src', '').show();
        button.siblings('.ce-img').val('').trigger('change');
    }
    $(document).on('click', '.ce-select-image', function(e){
        e.preventDefault();
        openMediaPicker($(this));
    });
    $(document).on('click', '.ce-delete-image', function(e){
        e.preventDefault();
        deleteMedia($(this));
    });
});