<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php get_header(); ?>
<?php
$author = get_queried_object();
?>
<header class="header title-container">
    <div class="container">
        <?php the_post(); ?>
        <h1 class="entry-title author" itemprop="name"><?php echo esc_attr($author->display_name); ?></h1>
        <div class="archive-meta" itemprop="description"><?php if ( '' != get_the_author_meta( 'user_description' ) ) { echo esc_html( get_the_author_meta( 'user_description' ) ); } ?></div>
            <?php rewind_posts(); ?>
        <div class="breadcrumb-wrap">
            <?php get_template_part('templates/breadcrumb'); ?>
        </div>
    </div>
</header>
<div class="container">
    <div class="postList">
        <?php 
        $cep_items = [
            "thumb"     =>  'y',
            "excerpt"   =>  'y',
            "term_out"  =>  'y',
            "tag_out"   =>  'y',
            "author"    =>  'n',
        ];
        ?>
        <?php while ( have_posts() ) : the_post(); ?>
            <?php get_template_part( 'templates/postList',null,$cep_items ); ?>
        <?php endwhile; ?>
        <?php get_template_part( 'nav', 'below' ); ?>
    </div>
</div>
<?php get_footer(); ?>