<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php

/*- こちらのファイルの編集は推奨していません -*/

/*
 CoreEdit Functions
----------------------------*/
function cep_cats($p_id,$split=''){
    global $CE_Settings;
    $type_obj = get_post_type_object(get_post_type( $p_id));
    $cat_tax = $type_obj->name === "post" 
        ? 'category' 
        : ( empty($CE_Settings['types'][$type_obj->name]['category']) 
            ? '' 
            : $CE_Settings['types'][$type_obj->name]['category'] );
    if(empty($cat_tax)){return '';}
    $cats = '';
    $cat_args = [
    'orderby'    => 'name',
    'order'      => 'ASC'
    ];
    if(!empty($cat_tax)) {
        $terms = wp_get_post_terms( $p_id, $cat_tax, $cat_args );
        $return_terms = '';
        foreach ( $terms as $index => $term ) {
            $return_terms .= '<a title="'.esc_attr( $term->name ).'" href="' . esc_url( get_term_link( $term ) ) . '" class="category ' . esc_attr( $term->taxonomy ) . ' ' . esc_attr( $term->slug ) . '">' . esc_html( $term->name ) . '</a>';
            if(count($terms)-1 > $index && !empty($split)) {
                $return_terms .= '<span>'.esc_html($split).'</span>';
            }
        }
    }
    return $return_terms;
}
function cep_tags($p_id,$split=''){
    global $CE_Settings;
    $type_obj = get_post_type_object(get_post_type( $p_id ));
    $tag_tax = $type_obj->name === "post" 
        ? 'post_tag' 
        : ( empty($CE_Settings['types'][$type_obj->name]['tag']) 
            ? '' 
            : $CE_Settings['types'][$type_obj->name]['tag'] );
    if(empty($tag_tax)){return '';}
    $tags = '';
    $tag_args = [
    'orderby'   => 'name',
    'order'     => 'ASC'
    ];
    if(!empty($tag_tax)) {
        $terms = wp_get_post_terms( $p_id, $tag_tax, $tag_args );
        $return_terms = '';
        foreach ( $terms as $index => $term ) {
            $return_terms .= '<a title="'.esc_attr( $term->name ).'" href="' . esc_url( get_term_link( $term ) ) . '" class="tag ' . esc_attr( $term->taxonomy ) . ' ' . esc_attr( $term->slug ) . '">' . esc_html( $term->name ) . '</a>';
            if(count($terms)-1 > $index && !empty($split)) {
                $return_terms .= '<span>'.esc_html($split).'</span>';
            }
        }
    }
    return $return_terms;
}
function CoreEdit_id_by_url( $url ) {
    global $wpdb;
    if(esc_url_raw($url)) {
        $attachment_id = $wpdb->get_var( $wpdb->prepare(
            "SELECT ID FROM $wpdb->posts WHERE guid=%s AND post_type='attachment'",
            esc_url_raw($url)
        ));
    }
    return $attachment_id ? (int)$attachment_id : false;
}
function Get_CE_Settings($str=''){
    global $CE_Settings;
    if(!empty($str) && array_key_exists($str, $CE_Settings)) {
        return $CE_Settings[$str];
    }else{
        return $CE_Settings;
    }
}

/*
Global変数の設定
*------------------*/
function Global_CoreEdit_Settings() {
    global $CE_Settings;
    $defaults = [
        'site_logo' => '',
        'site_favicon' => '',
        'cta_back' => '',
        'auto_nav' => '1',
        'section_num' => 10,
        'allowed_widgets' => array(),
        'types' => array(), 
        'card' => 'summary',
        'editor' => 'allowed',
        'styles' => array(),
        'css' => '',
        'header_type' => '1',
    ];
    $CE_Settings = get_option('CoreEdit_Settings', []);
    $CE_Settings = wp_parse_args($CE_Settings, $defaults);
    /*---------------------------------------------------
    // カテゴリーとタグの適応
    'types' = [
        'taxonomy_name' => [
            'category' => 'term_slug',
            'tag' => 'term_slug'
        ]
    ]

    // 管理者以外に編集を許可するウィジェット一覧
    'allowed_widgets' = ['widget_name1','widget_name2'...]

    // トップページセクション毎の基礎デザイン
    'styles' = [
        'section1' => [
            '_CE_Column' => 'stylename',
            '_CE_Slide' => 'stylename',
            '_CE_Post' => 'stylename',
            '_CE_ImgTxt' => 'stylename',
            '_CE_Txt' => 'stylename',
        ]
    ]

    ---------------------------------------------------*/
}
add_action('after_setup_theme', 'Global_CoreEdit_Settings');


/*
基本設定
*------------------*/

add_action( 'after_setup_theme', 'CoreEdit_setup' );
function CoreEdit_setup() {
load_theme_textdomain( 'coreedit', get_template_directory_uri() . '/languages' );
add_theme_support( 'title-tag' );
add_theme_support( 'custom-logo' );
add_theme_support( 'post-thumbnails' );
add_theme_support( 'responsive-embeds' );
add_theme_support( 'automatic-feed-links' );
add_theme_support( 'html5', array( 'search-form', 'navigation-widgets' ) );
add_theme_support( 'appearance-tools' );
add_theme_support( 'woocommerce' );
global $content_width;
if ( !isset( $content_width ) ) { $content_width = 1920; }
register_nav_menus( array( 'main-menu' => 'Main Menu','mobile-menu' => 'Mobile Menu' ) );
}


add_action( 'wp_enqueue_scripts', 'CoreEdit_enqueue' );
function CoreEdit_enqueue() {
wp_enqueue_script( 'jquery' );
wp_register_script( 'CoreEdit-videos', get_template_directory_uri() . '/assets/js/videos.js' );
wp_enqueue_script( 'CoreEdit-videos' );
wp_add_inline_script( 'CoreEdit-videos', 'jQuery(document).ready(function($){$("#wrapper").vids();});' );
}

add_action( 'wp_footer', 'CoreEdit_footer' );
function CoreEdit_footer() {
?>
<script>
jQuery(document).ready(function($) {
    let hed = $("#header");
    let hedp = hed.css("padding-top");
    let hbtm = $("#header").offset().top + $("#header").outerHeight(true);
    const pos = 150;
    const fa = "full-active";
    $(".before").on("focus", function() {
    $(".last").focus();
    });
    $(".after").on("focus", function() {
    $(".first").focus();
    });
    $("#mobile-toggle").on("keypress click", function(e) {
    if (e.which == 13 || e.type === "click") {
    e.preventDefault();
    $("#sp-menu").toggleClass(fa);
    $("html").toggleClass(fa);
    if($("#sp-menu").hasClass(fa)) {
    hbtm = $("#header").outerHeight(true);
    //$("nav#CoreEdit-mobile").css("padding-top",hbtm+"px");
    }}});
    $(document).keyup(function(e) {
    if (e.keyCode == 27) {
    if ($("#sp-menu").hasClass(fa)) {
    $("#sp-menu").toggleClass(fa);
    $("html").toggleClass(fa);
    }}
    });
    $("#search").on("keypress click", function(e) {
    if ((e.which == 13 || e.type === "click") && (! $("#search").hasClass(fa))) {
    e.preventDefault();
    $("#search").toggleClass(fa);
    $("html").toggleClass(fa);
    }});
    $("#search-close,.full-overlay.search").on("keypress click", function(e) {
    if ((e.which == 13 || e.type === "click")) {
    e.preventDefault();
    if ($("#search").hasClass(fa)) {
    $("#search").toggleClass(fa);
    $("html").toggleClass(fa);
    }return false;}
    });
    $(document).keyup(function(e) {
    if (e.keyCode == 27) {
    if ($("#search").hasClass(fa)) {
    $("#search").toggleClass(fa);
    $("html").toggleClass(fa);
    }}
    });
    $("img.no-logo").each(function() {
    var alt = $(this).attr("alt");
    $(this).replaceWith(alt);
    });
    $(window).scroll(function(e){
    if($(this).scrollTop() > (hbtm + pos) && (!($("html").hasClass("scrolled")))) {
    $("html").addClass("scrolled");
    //$("body").css("padding-top",hbtm+"px");
    }else if(($(this).scrollTop() + pos) < (hbtm + pos) && $("html").hasClass("scrolled")){
    //$("body").css("padding-top",hedp);
    $("html").removeClass("scrolled");
    }});
    let lastWidth = $(window).width();
    $(window).resize(function(){
    const currentWidth = $(window).width();
        if (currentWidth !== lastWidth) {
            $("#header").find("."+fa).each(function(i){
                if($(this).hasClass(fa)) {$(this).removeClass(fa);$('html').removeClass(fa);}
                lastWidth = currentWidth;
            });
        }
    });
});
</script>
<?php
}

add_action('check_code','ce_footer_check', PHP_INT_MAX);
function ce_footer_check() {
    $flug =  get_option('CEA_Flug','');
    if(!($flug === '認証成功')) {
        echo '<div id="developed-and-distributed" style="text-align:center;">CoreEdit is developed and distributed by <a href="https://coreedit.jp" target="_blank">https://coreedit.jp</a>. This is the free version.</div>';
    }
}

add_filter( 'document_title_separator', 'CoreEdit_document_title_separator' );
function CoreEdit_document_title_separator( $sep ) {
$sep = esc_html( '|' );
return $sep;
}
add_filter( 'the_title', 'CoreEdit_title' );
function CoreEdit_title( $title ) {
if ( $title == '' ) {
return esc_html( '...' );
} else {
return wp_kses_post( $title );
}
}


function CoreEdit_schema_type() {
$schema = 'https://schema.org/';
if ( is_single() ) {
$type = "Article";
} elseif ( is_author() ) {
$type = 'ProfilePage';
} elseif ( is_search() ) {
$type = 'SearchResultsPage';
} else {
$type = 'WebPage';
}
echo 'itemscope itemtype="' . esc_url( $schema ) . esc_attr( $type ) . '"';
}


add_filter( 'nav_menu_link_attributes', 'CoreEdit_schema_url', 10 );
function CoreEdit_schema_url( $atts ) {
$atts['itemprop'] = 'url';
return $atts;
}


if ( !function_exists( 'CoreEdit_wp_body_open' ) ) {
function CoreEdit_wp_body_open() {
do_action( 'wp_body_open' );
}
}


add_action( 'wp_body_open', 'CoreEdit_skip_link', 5 );
function CoreEdit_skip_link() {
echo '<a href="#content" class="skip-link screen-reader-text">' . 'Skip to the content' . '</a>';
}


add_filter( 'the_content_more_link', 'CoreEdit_read_more_link' );
function CoreEdit_read_more_link() {
if ( !is_admin() ) {
return ' <a href="' . esc_url( get_permalink() ) . '" class="more-link">' . sprintf( '...%s', '<span class="screen-reader-text">  ' . esc_html( get_the_title() ) . '</span>' ) . '</a>';
}
}


add_filter( 'excerpt_more', 'CoreEdit_excerpt_read_more_link' );
function CoreEdit_excerpt_read_more_link( $more ) {
if ( !is_admin() ) {
global $post;
return ' <a href="' . esc_url( get_permalink( $post->ID ) ) . '" class="more-link">' . sprintf( '...%s', '<span class="screen-reader-text">  ' . esc_html( get_the_title() ) . '</span>' ) . '</a>';
}
}


add_filter( 'big_image_size_threshold', '__return_false' );
add_filter( 'intermediate_image_sizes_advanced', 'CoreEdit_image_insert_override' );
function CoreEdit_image_insert_override( $sizes ) {
unset( $sizes['medium_large'] );
unset( $sizes['1536x1536'] );
unset( $sizes['2048x2048'] );
return $sizes;
}


add_action( 'widgets_init', 'CoreEdit_widgets_init' );
function CoreEdit_widgets_init() {
global $CE_Settings;
register_sidebar( array(
'name' => 'MobileMenuBefore',
'id' => 'mobile-menu__before',
'before_widget' => '<div id="%1$s" class="widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
register_sidebar( array(
'name' => 'MobileMenuAfter',
'id' => 'mobile-menu__after',
'before_widget' => '<div id="%1$s" class="widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
register_sidebar( array(
'name' => 'MobileMenuAfterBottom',
'id' => 'mobile-menu__after-bottom',
'before_widget' => '<div id="%1$s" class="widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
register_sidebar( array(
'name' => 'Hero',
'id' => 'hero',
'before_widget' => '<div id="%1$s" class="s-hero widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
for($x = 1 ; $x <= $CE_Settings['section_num'] ; $x++) {
register_sidebar( array(
'name' => 'section'.$x,
'id' => 'section'.$x,
'before_widget' => '<div id="%1$s" class="s-'.$x.' widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
}
register_sidebar( array(
'name' => 'Page Sidebar',
'id' => 'page-sidebar',
'before_widget' => '<div id="%1$s" class="s-page widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
register_sidebar( array(
'name' => 'Single Sidebar',
'id' => 'single-sidebar',
'before_widget' => '<div id="%1$s" class="s-single widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
register_sidebar( array(
'name' => 'Archive Sidebar',
'id' => 'archive-sidebar',
'before_widget' => '<div id="%1$s" class="s-archive widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
register_sidebar( array(
'name' => 'CTA',
'id' => 'cta',
'before_widget' => '<div id="%1$s" class="s-cta widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
register_sidebar( array(
'name' => 'Footer Area',
'id' => 'footer-area',
'before_widget' => '<div id="%1$s" class="s-footer widget widget-container %2$s">',
'after_widget' => '</div>',
'before_title' => '<h2 class="widget-title">',
'after_title' => '</h2>',
) );
}

add_action( 'wp_head', 'CoreEdit_pingback_header' );
function CoreEdit_pingback_header() {
if ( is_singular() && pings_open() ) {
printf( '<link rel="pingback" href="%s">' . "\n", esc_url( get_bloginfo( 'pingback_url' ) ) );
}
}

add_action( 'comment_form_before', 'CoreEdit_enqueue_comment_reply_script' );
function CoreEdit_enqueue_comment_reply_script() {
if ( get_option( 'thread_comments' ) ) {
wp_enqueue_script( 'comment-reply' );
}
}
function CoreEdit_custom_pings( $comment ) {
?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>"><?php echo esc_url( comment_author_link() ); ?></li>
<?php
}

add_filter( 'get_comments_number', 'CoreEdit_comment_count', 0 );
function CoreEdit_comment_count( $count ) {
if ( !is_admin() ) {
global $id;
$get_comments = get_comments( 'status=approve&post_id=' . $id );
$comments_by_type = separate_comments( $get_comments );
return count( $comments_by_type['comment'] );
} else {
return $count;
}
}
add_action( 'wp_head', 'ce_custom_ogp_tags' );
function ce_custom_ogp_tags() {
global $post;
global $CE_Settings;
$title = '';
$description = '';
$url = '';
$image = '';
$site_name = esc_attr( get_bloginfo('name') );
$default_image = esc_url( ce_get_site_favicon_url() );
$keywords = '';
if ( is_front_page() ) {
$title = esc_attr( get_bloginfo('name') );
$description = esc_attr( get_bloginfo('description') );
$url = esc_url( home_url( '/' ) );
$image = $default_image;
} elseif ( is_singular() && isset( $post ) ) {
setup_postdata( $post );
$title = esc_attr( wp_strip_all_tags( get_the_title() ) );
$description = has_excerpt( $post->ID )
? esc_attr( wp_strip_all_tags( get_the_excerpt() ) )
: esc_attr( wp_strip_all_tags( get_bloginfo('description') ) );
$url = esc_url( get_permalink() );
$image = has_post_thumbnail( $post->ID )
? esc_url( get_the_post_thumbnail_url( $post->ID, 'full' ) )
: $default_image;
if(!is_page()) {
$tags = cep_tags($post->ID);
if(!empty($tags)) {
$tags = cep_tags($post->ID);
preg_match_all('/<a[^>]*>(.*?)<\/a>/', $tags, $matches);
$texts = $matches[1];
$keywords = implode(',', $texts);
}
}
$keywords = apply_filters('ce_meta_keywords',$keywords);
wp_reset_postdata();
} elseif ( is_archive() || is_home() ) {
$title = esc_attr( wp_title('', false) ?: get_bloginfo('name') );
$description = esc_attr( get_bloginfo('description') );
$url = esc_url( get_permalink() );
$image = $default_image;
}
echo <<<HTML
<meta name="description" content="{$description}">
<meta name="keywords" content="{$keywords}">
<!--OGP-->
<meta property="og:title" content="{$title}" />
<meta property="og:description" content="{$description}" />
<meta property="og:url" content="{$url}" />
<meta property="og:type" content="article" />
<meta property="og:image" content="{$image}" />
<meta property="og:site_name" content="{$site_name}" />
<meta name="twitter:card" content="{$CE_Settings['card']}" />
<meta name="twitter:title" content="{$title}" />
<meta name="twitter:description" content="{$description}" />
<meta name="twitter:image" content="{$image}" />
<!--/OGP-->
HTML;
wp_reset_postdata();
}
function ce_get_site_favicon_url() {
    $site_icon_id = get_option('site_icon');
    if ( $site_icon_id ) {
        $icon_url = wp_get_attachment_image_url( $site_icon_id, 'full' );
        if ( $icon_url ) {
            return $icon_url;
        }
    }
    return includes_url('images/w-logo-blue.png');
}
//enqueue
add_action('wp_head', 'ce_custom_css');
function ce_custom_css() {
    global $CE_Settings;
    $custom_css = $CE_Settings['css'];
    if ($custom_css) {
        echo '<style id="ce-custom-css">' . wp_strip_all_tags($custom_css) . '</style>';
    }
}
add_action('wp_enqueue_scripts','ce_enqueue');
function ce_enqueue(){
    wp_enqueue_style('ce-main-css', get_template_directory_uri().'/style.css', [], null);
    if ( file_exists( get_stylesheet_directory() . '/assets/css/common.css' ) ) {
        wp_enqueue_style('ce-cm-css', get_stylesheet_directory_uri() . '/assets/css/common.css', [], null);
    } else {
        wp_enqueue_style('ce-cm-css', get_template_directory_uri() . '/assets/css/common.css', [], null);
    }
    if ( file_exists( get_stylesheet_directory() . '/assets/js/common.js' ) ) {
        wp_enqueue_script('ce-cm-css', get_stylesheet_directory_uri().'/assets/js/common.js', [], null, true);
    } else {
        wp_enqueue_script('ce-cm-css', get_template_directory_uri().'/assets/js/common.js', [], null, true);
    }
    if ( file_exists( get_stylesheet_directory() . '/widgets/slide/slide-front.js' ) ) {
        wp_enqueue_script('ce-sf-js', get_stylesheet_directory_uri().'/widgets/slide/slide-front.js', [], null, true);
    } else {
        wp_enqueue_script('ce-sf-js', get_template_directory_uri().'/widgets/slide/slide-front.js', [], null, true);
    }
}
add_action('admin_enqueue_scripts','ce_admin_enqueue');
function ce_admin_enqueue() {
    wp_enqueue_style('ce-dash-css', get_template_directory_uri().'/assets/css/dashboard.css', [], null);
}
//dequeue
//add_action('wp_enqueue_scripts', 'ce_remove_block_library_css', 100);
function ce_remove_block_library_css() {
    wp_dequeue_style('wp-block-library');
    wp_dequeue_style('wp-block-library-theme');
    wp_dequeue_style('wc-blocks-style');
}
function ce_convert_relative_url_to_absolute($relative_url, $css_file_path) {
if (preg_match('/^(data:|https?:|\/)/i', $relative_url)) {
return $relative_url;
}
$base_dir = dirname($css_file_path);
$full_path = realpath($base_dir . '/' . $relative_url);
$theme_dir = realpath(get_template_directory());
$theme_uri = get_template_directory_uri();
if ($full_path && strpos($full_path, $theme_dir) === 0) {
$relative_path = str_replace($theme_dir, '', $full_path);
return $theme_uri . $relative_path;
}
return $theme_uri . '/' . ltrim($relative_url, '/');
}

/*
アーカイブの表記を[ アーカイブ:投稿 ]形式から[ 投稿 ]形式へ
--------------------------------------*/
add_filter( 'get_the_archive_title', 'CoreEdit_archive_title' );
function CoreEdit_archive_title( $title ) {
if ( is_category() ) {
$title = single_cat_title( '', false );
} elseif ( is_tag() ) {
$title = single_tag_title( '', false );
} elseif ( is_author() ) {
$title = get_the_author();
} elseif ( is_post_type_archive() ) {
$title = post_type_archive_title( '', false );
} elseif ( is_tax() ) {
$title = single_term_title( '', false );
} elseif (is_year()){
$title = get_query_var('year').'年';
} elseif (is_day()) {
$title = get_query_var('year').'年'.get_query_var('monthnum').'月'.get_query_var('day').'日';
} elseif (is_date()) {
$title = get_query_var('year').'年'.get_query_var('monthnum').'月';
}
return $title;
}



/*
投稿アーカイブ許可
----------------------------*/
add_filter( 'register_post_type_args', 'CoreEdit_post_has_archive', PHP_INT_MAX, 2 );
function CoreEdit_post_has_archive( $args, $post_type ) {
if ( 'post' == $post_type ) {
$args['has_archive'] = 'post';
$args['rewrite'] = ['slug' => 'post'];
}
return $args;
}


/*
CoreEditウィジェット
----------------------------*/
get_template_part("widgets/nav/nav");
get_template_part("widgets/slide/slide");
get_template_part("widgets/imgtxt/imgtxt");
get_template_part("widgets/text/text");
get_template_part("widgets/post/post");
add_action('admin_enqueue_scripts', function($hook) {
if ($hook === 'widgets.php') {
wp_enqueue_media();
wp_enqueue_script('ce-widgets', get_template_directory_uri() . '/widgets/js/widgets.js', array('jquery'), null, true);
wp_enqueue_style('ce-widgets',get_template_directory_uri() . '/widgets/css/widgets.css');
wp_enqueue_editor();
}
});


/*
アーカイブウィジェット　年別
----------------------------*/
add_filter( 'widget_archives_args','CoreEdit_archives');
function CoreEdit_archives( $content ){
$content['type'] 	= 'yearly';
$content['after'] 	= '';
$content['limit'] 	= 99;
return $content;
}

/*
メディア詳細ページの自動生成停止
----------------------------*/
add_filter( 'option_wp_attachment_pages_enabled', '__return_false' );


/*
ウィジェットのクラシック化
----------------------------*/
add_filter('use_widgets_block_editor', '__return_false');


/*
CoreEdit 設定画面
----------------------------*/
add_action('admin_init', 'ce_disable_customizer');
function ce_disable_customizer() {
if (is_admin() && isset($_GET['customize_changeset_uuid'])) {
wp_die('カスタマイザーは無効化されています。');
}
}
add_action('admin_bar_menu', 'ce_remove_customize_admin_bar', 999);
function ce_remove_customize_admin_bar($wp_admin_bar) {
$wp_admin_bar->remove_node('customize');
}
add_action('admin_menu', 'ce_remove_customize_menu', 999);
function ce_remove_customize_menu() {
remove_submenu_page('themes.php', 'customize.php');
}
add_filter('map_meta_cap', 'ce_disable_customize_capabilities', 10, 2);
function ce_disable_customize_capabilities($caps, $cap) {
if ($cap === 'customize') {
return ['do_not_allow'];
}
return $caps;
}
add_action('admin_enqueue_scripts', 'CoreEdit_widget_setting');
function CoreEdit_widget_setting() {
$screen = get_current_screen();
if (!('administrator' === wp_get_current_user()->roles[0]) && $screen->id === 'widgets') {
add_action('admin_footer-widgets.php', function () {
?>
<script>
jQuery(document).ready(function ($) {
$('.widget-control-remove').hide();
$('.widget-liquid-left').hide();
$('.page-title-action.hide-if-no-customize').hide();
$('.widget-access-link').hide();
$('#contextual-help-link-wrap').hide();
$('.widgets-sortables').sortable('disable');
$('#available-widgets .widget').draggable('disable');
$('div.widget-liquid-right').css('float','left');
});
</script>
<?php
});
}
}
add_action('init', 'CoreEdit_allow_editors_to_access_widgets');
function CoreEdit_allow_editors_to_access_widgets() {
global $CE_Settings;
$role = get_role('editor');
if ($role && (empty($CE_Settings['editor']) || $CE_Settings['editor'] === 'deallowed')) {
$role->remove_cap('edit_theme_options');
}elseif($role && (!empty($CE_Settings['editor']) || $CE_Settings['editor'] === 'allowed')){
$role->add_cap('edit_theme_options');
}
}
add_action('admin_menu', 'CoreEdit_restrict_appearance_menu_for_editors', 999);
function CoreEdit_restrict_appearance_menu_for_editors() {
if (current_user_can('editor') && !('administrator' === wp_get_current_user()->roles[0])) {
remove_submenu_page('themes.php', 'themes.php');
remove_submenu_page('themes.php', 'nav-menus.php');
}
}
add_action('admin_init', 'ce_block_customize_and_site_editor_access_strict');
function ce_block_customize_and_site_editor_access_strict() {
if (!('administrator' === wp_get_current_user()->roles[0])) {
$request_uri = $_SERVER['REQUEST_URI'];
if (strpos($request_uri, 'customize.php') !== false 
|| strpos($request_uri, 'site-editor.php') !== false
|| strpos($request_uri, 'themes.php') !== false
|| strpos($request_uri, 'nav-menus.php')
|| strpos($request_uri, 'theme-editor.php')) {
wp_redirect(admin_url('widgets.php'));
exit;
}
}
}
add_action('admin_head', 'ce_hide_site_editor_and_customizer_menu');
function ce_hide_site_editor_and_customizer_menu() {
if (current_user_can('editor') && !('administrator' === wp_get_current_user()->roles[0])) {
echo '<style>
#menu-appearance a[href*="customize.php"],
#menu-appearance a[href*="site-editor.php"] + ul a[href*="site-editor.php"] {
    display: none !important;
}
</style>';
}
}

/*
 CoreEdit author post type
----------------------------*/
add_action( 'pre_get_posts', 'ce_author_archive_query' );
function ce_author_archive_query( $query ) {
    if ( is_admin() || ! $query->is_main_query() ) {
        return;
    }
    
    $post_types = get_post_types(['public' => true,'hierarchical' => false], 'objects');
    $type_names = array();
    foreach($post_types as $type_obj) { 
        if ( in_array( $type_obj->name, ['attachment', 'revision', 'nav_menu_item'], true ) ) {continue;}
        $type_names[] = $type_obj->name;
    }
    if ( $query->is_author() ) {
        $query->set( 'post_type', $type_names );
    }
}


/*
 CoreEdit Base Setting
----------------------------*/
add_action('admin_menu', 'CoreEdit_settings_page');
function CoreEdit_settings_page() {
add_menu_page(
'CoreEdit',
'CoreEdit',
'administrator',
'CoreEdit_settings',
'CoreEdit_settings_page_html',
'dashicons-admin-generic'
);
add_submenu_page(
'CoreEdit_settings',
'基本設定',
'基本設定',
'administrator',
'CoreEdit_settings',
'CoreEdit_settings_page_html',
);
add_submenu_page(
'CoreEdit_settings',
'セクション設定',
'セクション設定',
'administrator',
'CoreEdit_settings2',
'CoreEdit_settings_page_html2',
);
add_submenu_page(
'CoreEdit_settings',
'カスタムCSS',
'カスタムCSS',
'administrator',
'CoreEdit_settings3',
'CoreEdit_settings_page_html3',
);
add_submenu_page(
'CoreEdit_settings',
'ライセンス認証',
'ライセンス認証',
'administrator',
'CoreEdit_settings4',
'CoreEdit_settings_page_html4',
);
}
function CoreEdit_settings_page_html() {
    if(!('administrator' === wp_get_current_user()->roles[0])) {
    return;
    }
    $post_types = get_post_types(['public' => true,'hierarchical' => false], 'objects');
    global $CE_Settings;
    global $wp_widget_factory;
    $widgets = array_keys($wp_widget_factory->widgets);
    $slogo = !empty($CE_Settings["site_logo"]) ? $CE_Settings["site_logo"] : '';
    $sfavi = !empty($CE_Settings["site_favicon"]) ? $CE_Settings["site_favicon"] : '';
    ?>
    <div class="wrap">
    <h1>CoreEdit基本設定</h1>
    <div class="postbox">
    <div class="inside">
    <form method="post">
    <table class="form-table vertical">
    <tr>
        <th scope="row"><label>サイトロゴ設定</label></th>
        <td>
            <div class="ce-img-selecter">
                <img class="ce-image-preview" src="<?php echo esc_url($slogo); ?>" 
                style="max-width:250px; height:auto; <?php echo empty($slogo) ? 'display:none;' : ''; ?>" />
                <div class="bt-wrap">
                    <button class="button ce-select-image">画像を選択</button>
                    <button class="button ce-delete-image">画像を削除</button>
                    <input type="hidden" class="ce-img" 
                    id="ce-site-logo-field" 
                    name="ce-site-logo" 
                    value="<?php echo esc_attr($slogo); ?>" />
                </div>
            </div>
        </td>
    </tr>
    <tr>
        <th scope="row"><label>ファビコン設定(512×512推奨)</label></th>
        <td>
            <div class="ce-img-selecter">
                <img style="max-height:96px;"  class="ce-image-preview" src="<?php echo esc_url($sfavi); ?>" 
                style="max-width:256px; height:auto; <?php echo empty($sfavi) ? 'display:none;' : ''; ?>" />
                <div class="bt-wrap">
                    <button class="button ce-select-image">画像を選択</button>
                    <button class="button ce-delete-image">画像を削除</button>
                    <input type="hidden" class="ce-img" 
                    id="ce-favicon-field" 
                    name="ce-favicon" 
                    value="<?php echo esc_attr($sfavi); ?>" />
                </div>
            </div>
        </td>
    </tr>
    <tr>
        <th scope="row"><label>CTA背景画像設定</label></th>
        <td>
            <div class="ce-img-selecter">
                <img style="max-height:95px;" class="ce-image-preview" src="<?php echo esc_url($CE_Settings["cta_back"]); ?>" 
                style="max-width:250px; height:auto; <?php echo empty($CE_Settings["cta_back"]) ? 'display:none;' : ''; ?>" />
                <div class="bt-wrap">
                    <button class="button ce-select-image">画像を選択</button>
                    <button class="button ce-delete-image">画像を削除</button>
                    <input type="hidden" class="ce-img" 
                    id="ce-cta-back-id" 
                    name="ce-cta-back" 
                    value="<?php echo esc_attr($CE_Settings["cta_back"]); ?>" />
                </div>
            </div>
        </td>
    </tr>
    <tr>
        <th scope="row"><label>ヘッダータイプ選択</label></th>
        <td>
            <select name="ce-header-type">
            <option value="1" <?php selected($CE_Settings['header_type'],"1"); ?>>スタンダード</option>
            <option value="2" <?php selected($CE_Settings['header_type'],"2"); ?>>スタンダート(バーガーメニュー常設)</option>
            <option value="3" <?php selected($CE_Settings['header_type'],"3"); ?>>サイドヘッダー(バーガーメニュー常設)</option>
            </select>
        </td>
    </tr>
    <tr>
        <th scope="row"><label>固定ページ自動メニュー出力</label></th>
        <td>
            <label>
            <input type="radio" name="ce_auto_nav" value="1" <?php checked($CE_Settings['auto_nav'], '1'); ?>>
            あり
            </label><br>
            <label>
            <input type="radio" name="ce_auto_nav" value="0" <?php checked($CE_Settings['auto_nav'], '0'); ?>>
            なし
            </label>
        </td>
    </tr>
    <tr>
        <th scope="row"><label>Twitterカードタイプ選択(OGP)</label></th>
        <td>
            <label>
            <input type="radio" name="ce_twitter_card" value="summary" <?php checked($CE_Settings['card'], 'summary'); ?>>
            小サイズ
            </label><br>
            <label>
            <input type="radio" name="ce_twitter_card" value="summary_large_image" <?php checked($CE_Settings['card'], 'summary_large_image'); ?>>
            大サイズ
            </label>
        </td>
    </tr>
    <tr>
        <th scope="row"><label>編集者のウィジェット利用許可</label></th>
        <td>
            <label>
            <input type="radio" name="ce_allowed_editor" value="allowed" <?php checked($CE_Settings['editor'], 'allowed'); ?>>
            許可
            </label><br>
            <label>
            <input type="radio" name="ce_allowed_editor" value="deallowed" <?php checked($CE_Settings['editor'], 'deallowed'); ?>>
            不許可
            </label>
        </td>
    </tr>
    <tr>
        <th scope="row"><label >編集者へ表示するウィジェット</label></th>
        <td>
            <?php
            foreach($widgets as $widget) {
            $widget_name = $wp_widget_factory->widgets[$widget]->name;
            ?>
            <label>
            <input type="checkbox" name="ce_allowed_widgets[]" value="<?php echo esc_attr($widget); ?>" 
            <?php echo in_array($widget, $CE_Settings['allowed_widgets']) ? 'checked' : ''; ?>>
            <?php echo esc_html($widget_name); ?>
            </label><br>
            <?php
            }
            ?>
        </td>
    </tr>
    <tr>
        <th scope="row"><label>投稿タイプ毎のタクソノミー管理</label></th>
        <td>
            <?php 
            if(count($post_types) < 3 ) {echo "<p>カスタム投稿タイプがありません。</p>";}
            foreach($post_types as $type_obj) { 
            if ( in_array( $type_obj->name, ['post','attachment', 'revision', 'nav_menu_item'], true ) ) {continue;}
            ?>
            <p>投稿タイプ : <?php echo esc_html($type_obj->label); ?></p>
            <?php
            $taxonomies = get_object_taxonomies($type_obj->name, 'objects');
            if(!empty($taxonomies)){
            $ce_cat = (!empty($CE_Settings['types'][$type_obj->name]) && !empty($CE_Settings['types'][$type_obj->name]['category'])) ? $CE_Settings['types'][$type_obj->name]['category'] : "";
            ?>
            <label><small>カテゴリー</small></label><br>
            <select name="<?php echo esc_attr($type_obj->name); ?>__ce_cate_tax">
            <option value="" <?php selected($ce_cat,""); ?>>選択してください</option>
            <?php
            foreach($taxonomies as $key => $tax) {
            ?><option value="<?php echo esc_attr($key); ?>" <?php selected($ce_cat,$key); ?>><?php echo esc_html($tax->label); ?></option><?php
            }
            ?></select><br>
            <?php if(count($taxonomies) < 2) {continue;} ?>
            <?php $ce_tag = (!empty($CE_Settings['types'][$type_obj->name]) && !empty($CE_Settings['types'][$type_obj->name]['tag'])) ? $CE_Settings['types'][$type_obj->name]['tag'] : ""; ?>
            <lable><small>タグ</small></label><br>
            <select name="<?php echo esc_attr($type_obj->name); ?>__ce_tag_tax">
            <option value="" <?php selected($ce_tag,""); ?>>選択してください</option>
            <?php
            foreach($taxonomies as $key => $tax) {
            ?><option value="<?php echo esc_attr($key); ?>" <?php selected($ce_tag,$key); ?>><?php echo esc_html($tax->label); ?></option><?php
            }
            ?></select><?php
            }
            ?>
            <?php } ?>
        </td>
    </tr>
    </table>
    <br>
    <input type="submit" class="button button-primary" value="設定を保存">
    </form>
    </div>
    </div>
    </div>
    <?php
    $up_flug = false;
    if(isset($_POST['ce-site-logo']) && is_string($_POST['ce-site-logo'])) {
        $update_str = esc_url_raw($_POST['ce-site-logo']);
        $CE_Settings['site_logo'] = $update_str;
        $logo_url = !empty($update_str) ? $update_str : '';
        $logo_id = CoreEdit_id_by_url($logo_url);
        set_theme_mod( 'custom_logo', $logo_id );
        $up_flug = true;
    }
    if(isset($_POST['ce-favicon']) && is_string($_POST['ce-favicon'])) {
        $update_str = esc_url_raw($_POST['ce-favicon']);
        $CE_Settings['site_favicon'] = $update_str;
        $icon_url = !empty($update_str) ? $update_str : '';
        $icon_id = CoreEdit_id_by_url($icon_url);
        set_theme_mod( 'site_icon', $icon_id );
        if ($icon_id) {
        $sizes = ['32x32', '192x192'];
        foreach ($sizes as $size) {
            $image = wp_get_attachment_image_src($icon_id, $size);
            if (!$image) {
                $full = wp_get_attachment_image_src($icon_id, 'full');
                if ($full) {
                    $editor = wp_get_image_editor($full[0]);
                    if (!is_wp_error($editor)) {
                        $editor->resize(...explode('x', $size));
                        $dest = get_attached_file($icon_id);
                        $editor->save($dest);
                    }
                }
            }
        }
        }
        $up_flug = true;
    }
    if(isset($_POST['ce-cta-back']) && is_string($_POST['ce-cta-back'])) {
        $update_str = esc_url_raw($_POST['ce-cta-back']);
        $CE_Settings['cta_back'] = $update_str;
        $up_flug = true;
    }
    if(isset($_POST['ce-header-type']) && is_string($_POST['ce-header-type'])) {
        $ce_htype = sanitize_text_field($_POST['ce-header-type']);
        $CE_Settings['header_type'] = $ce_htype;
        $up_flug = true;
    }
    if(isset($_POST['ce_auto_nav']) && is_string($_POST['ce_auto_nav'])) {
        $ce_anav = sanitize_text_field($_POST['ce_auto_nav']);
        $CE_Settings['auto_nav'] = $ce_anav;
        $up_flug = true;
    }
    if(isset($_POST['ce_allowed_widgets']) && is_array($_POST['ce_allowed_widgets'])) {
        $allowed_widgets = array_map('sanitize_text_field', $_POST['ce_allowed_widgets']);
        $CE_Settings['allowed_widgets'] = $allowed_widgets;
        $up_flug = true;
    }
    if(isset($_POST['ce_twitter_card']) && is_string($_POST['ce_twitter_card'])) {
        $card_type = sanitize_text_field($_POST['ce_twitter_card']);
        $CE_Settings['card'] = $card_type;
        $up_flug = true;
    }
    foreach($post_types as $type_obj) {
        if((isset($_POST[$type_obj->name.'__ce_cate_tax']) && is_string($_POST[$type_obj->name.'__ce_cate_tax']))) {
            $update_str = sanitize_text_field($_POST[$type_obj->name.'__ce_cate_tax']);
            $CE_Settings['types'][$type_obj->name]['category'] = $update_str;
            $up_flug = true;
        }
        if((isset($_POST[$type_obj->name.'__ce_tag_tax']) && is_string($_POST[$type_obj->name.'__ce_tag_tax']))) {
            $update_str = sanitize_text_field($_POST[$type_obj->name.'__ce_tag_tax']);
            $CE_Settings['types'][$type_obj->name]['tag'] = $update_str;
            $up_flug = true;
        }
    }
    if($up_flug) {
        update_option('CoreEdit_Settings', $CE_Settings);
        echo '<script>location.reload();</script>';
    }
}
function CoreEdit_get_all_widget_class_map() {
    global $wp_widget_factory;
    $map = [];
    foreach($wp_widget_factory->widgets as $class_name => $widget_obj) {
        $base_id = $widget_obj->id_base;
        $map[$base_id] = $class_name;
    }
    return $map;
}
add_action('admin_enqueue_scripts', 'CoreEdit_enqueue_hide_disallowed_widgets_js');
function CoreEdit_enqueue_hide_disallowed_widgets_js() {
    if (!('administrator' === wp_get_current_user()->roles[0]) && is_admin()) {
        global $CE_Settings;
        wp_enqueue_script(
        'CoreEdit-hide-widgets-by-permission',get_template_directory_uri() . '/assets/js/hide-widgets.js',['jquery'],null,true);
        wp_localize_script('CoreEdit-hide-widgets-by-permission', 'CEAllowedWidgetsData', [
        'allowed' => $CE_Settings['allowed_widgets'],
        'widgetClassMap' => CoreEdit_get_all_widget_class_map()
        ]);
    }
}
add_action('admin_enqueue_scripts', 'CoreEdit_standard_js');
function CoreEdit_standard_js($hook) {
    if ($hook !== 'toplevel_page_CoreEdit_settings') {return;}
    wp_enqueue_media();
    wp_enqueue_script('ce-images', get_template_directory_uri() . '/assets/js/images.js', array('jquery'), null, true);
}
add_action('wp_head', function() {
    $icon_id = get_theme_mod('site_icon');
    if (!$icon_id) return;
    $sizes = ['32x32', '192x192'];
    foreach ($sizes as $size) {
        $url = wp_get_attachment_image_src($icon_id, $size);
        if ($url) {
            echo '<link rel="icon" href="' . esc_url($url[0]) . '" sizes="' . esc_attr($size) . '">';
        }
    }
});
add_action('admin_head', function() {
    $icon_id = get_theme_mod('site_icon');
    if (!$icon_id) return;
    $sizes = ['32x32', '192x192'];
    foreach ($sizes as $size) {
        $url = wp_get_attachment_image_src($icon_id, $size);
        if ($url) {
            echo '<link rel="icon" href="' . esc_url($url[0]) . '" sizes="' . esc_attr($size) . '">';
        }
    }
});
add_action('wp_head', function() {
    global $CE_Settings;
    if($CE_Settings['cta_back']) {
        ?>
        <style>
            body #CTA { background-image: url(<?php echo $CE_Settings['cta_back']; ?>); }
        </style>
        <?php
    }
});
/*
 CoreEdit Section
----------------------------*/
function CoreEdit_settings_page_html2() {
    if(!('administrator' === wp_get_current_user()->roles[0])) {
        return;
    }
    global $wp_registered_sidebars;
    global $CE_Settings;
    ?>
    <div class="wrap">
    <h1>CoreEditセクション設定</h1>
    <div class="postbox">
    <div class="inside">
    <form method="post">
    <table class="form-table vertical">
        <tr>
            <th><h2 style="margin:0px;padding:0px;">フロントページセクション数</h2></th>
            <td>
                <div>
                <input type="number" max="30" min="1" step="1" value="<?php echo esc_attr($CE_Settings['section_num']); ?>" name="ce_section_num" />
                </div>
            </td>
        </tr>
        <?php
        foreach ( $wp_registered_sidebars as $sidebar ) {
        if(!str_starts_with($sidebar['id'], "section")) {continue;}
        $cecolumn = !empty($CE_Settings['styles'][$sidebar['id']]["_CE_Column"]) ? esc_attr($CE_Settings['styles'][$sidebar['id']]["_CE_Column"]) : "c1";
        $ceslide = !empty($CE_Settings['styles'][$sidebar['id']]["_CE_Slide"]) ? esc_attr($CE_Settings['styles'][$sidebar['id']]["_CE_Slide"]) : "";
        $cepost = !empty($CE_Settings['styles'][$sidebar['id']]["_CE_Post"]) ? esc_attr($CE_Settings['styles'][$sidebar['id']]["_CE_Post"]) : "";
        $ceimgtxt = !empty($CE_Settings['styles'][$sidebar['id']]["_CE_ImgTxt"]) ? esc_attr($CE_Settings['styles'][$sidebar['id']]["_CE_ImgTxt"]) : "";
        $cetxt = !empty($CE_Settings['styles'][$sidebar['id']]["_CE_Txt"]) ? esc_attr($CE_Settings['styles'][$sidebar['id']]["_CE_Txt"]) : "";
        echo '<tr><th><h2 style="margin:0px;padding:0px;">'.esc_html($sidebar['name']).'</h2></th>';
        echo '<td><div class="ce-style"><div><label>カラム数</label><br>
        <select name="'.esc_attr($sidebar['id']).'_CE_Column">
        <option value="c1" '.selected($cecolumn,"c1",false).'>1列</option>
        <option value="c2" '.selected($cecolumn,"c2",false).'>2列</option>
        <option value="c3" '.selected($cecolumn,"c3",false).'>3列</option>
        <option value="c4" '.selected($cecolumn,"c4",false).'>4列</option>
        <option value="c5" '.selected($cecolumn,"c5",false).'>5列</option>
        </select></div></div></td></tr>';
        }
        ?>
    </table>
    <input type="submit" class="button button-primary" value="設定を保存">
    </form>
    </div>
    </div>
    </div>
    <?php
    $up_flug = false;
    if((isset($_POST['ce_section_num']) && (filter_var($_POST['ce_section_num'], FILTER_VALIDATE_INT) !== false))) {
        $CE_Settings['section_num'] = intval($_POST['ce_section_num']);
        $up_flug = true;
    }
    foreach ( $wp_registered_sidebars as $sidebar ) {
        $target_slug = $sidebar['id'];
        if((isset($_POST[$target_slug.'_CE_Column']) && is_string($_POST[$target_slug.'_CE_Column']))) {
            $update_str = sanitize_text_field($_POST[$target_slug.'_CE_Column']);
            $CE_Settings['styles'][$target_slug]['_CE_Column'] = $update_str;
            $up_flug = true;
        }
        if((isset($_POST[$target_slug.'_CE_Slide_style']) && is_string($_POST[$target_slug.'_CE_Slide_style']))) {
            $update_str = sanitize_text_field($_POST[$target_slug.'_CE_Slide_style']);
            $CE_Settings['styles'][$target_slug]['_CE_Slide'] = $update_str;
            $up_flug = true;
        }
        if((isset($_POST[$target_slug.'_CE_Post_style']) && is_string($_POST[$target_slug.'_CE_Post_style']))) {
            $update_str = sanitize_text_field($_POST[$target_slug.'_CE_Post_style']);
            $CE_Settings['styles'][$target_slug]['_CE_Post'] = $update_str;
            $up_flug = true;
        }
        if((isset($_POST[$target_slug.'_CE_ImgTxt_style']) && is_string($_POST[$target_slug.'_CE_ImgTxt_style']))) {
            $update_str = sanitize_text_field($_POST[$target_slug.'_CE_ImgTxt_style']);
            $CE_Settings['styles'][$target_slug]['_CE_ImgTxt'] = $update_str;
            $up_flug = true;
        }
        if((isset($_POST[$target_slug.'_CE_Txt_style']) && is_string($_POST[$target_slug.'_CE_Txt_style']))) {
            $update_str = sanitize_text_field($_POST[$target_slug.'_CE_Txt_style']);
            $CE_Settings['styles'][$target_slug]['_CE_Txt'] = $update_str;
            $up_flug = true;
        }
    }
    if($up_flug) {
        update_option('CoreEdit_Settings', $CE_Settings);
        echo '<script>location.reload();</script>';
    }
}
/*
 CoreEdit Custom CSS
----------------------------*/
function CoreEdit_settings_page_html3() {
    if(!('administrator' === wp_get_current_user()->roles[0])) {
        return;
    }
    global $wp_registered_sidebars;
    global $CE_Settings;
    $CE_Settings['css'] = !empty($CE_Settings['css']) ? $CE_Settings['css'] : '';
    ?>
    <div class="wrap">
    <h1>CoreEditカスタムCSS</h1>
    <div class="postbox">
    <div class="inside">
    <p>以下の４つのブレイクポイントを使用しています。<br>@media(min-width:1025px){}<br>@media(max-width:1024px){}<br>@media(min-width:781px){}<br>@media(max-width:780px){}</p>
    <form method="post">
    <div class="postbox">
    <textarea id="ce_custom_css_field" name="ce_custom_css" rows="15" cols="80"><?php echo esc_textarea($CE_Settings['css']); ?></textarea>
    </div>
    <input type="submit" class="button button-primary" value="設定を保存">
    </form>
    </div>
    </div>
    </div>
    <?php
    $up_flug = false;
    if((isset($_POST['ce_custom_css']) && is_string($_POST['ce_custom_css']))) {
        $update_str = sanitize_textarea_field($_POST['ce_custom_css']);
        $CE_Settings['css'] = $update_str;
        $up_flug = true;
    }
    if($up_flug) {
        update_option('CoreEdit_Settings', $CE_Settings);
        echo '<script>location.reload();</script>';
    }
}
add_action('admin_enqueue_scripts', 'ce_custom_css_cm');
function ce_custom_css_cm($hook) {
    if ($hook !== 'coreedit_page_CoreEdit_settings3') { return; }
    $settings = wp_enqueue_code_editor(['type' => 'text/css']);
    if ($settings) {
        wp_enqueue_script('wp-theme-plugin-editor');
        wp_enqueue_style('wp-codemirror');
        wp_add_inline_script(
        'wp-theme-plugin-editor',
        'jQuery(function($){ wp.codeEditor.initialize($("#ce_custom_css_field"), ' . wp_json_encode($settings) . '); });'
        );
    }
}
/*
 CoreEdit Authentication Code Page
----------------------------*/
function CoreEdit_settings_page_html4() {
    if(!('administrator' === wp_get_current_user()->roles[0])) {
        return;
    }
    $CE_Code = get_option('CoreEdit_Auth', '');
    $CEA = get_option('CEA_Flug','');
    $CE_Str = CoreEdit_Authentication_Code($CE_Code,'check');
    ?>
    <div class="wrap">
    <h1>CoreEditライセンス認証</h1>
    <div class="postbox">
    <div class="inside">
    <p>１ライセンスにつき１サイトのみご利用いただけます。</p>
    <?php
    if(empty($CE_Str) && !empty($CEA) && $CEA !== "解除成功") {
        echo "<p style='color:red;'>".$CEA."</p>";
        update_option('CEA_Flug','');
    }elseif(empty($CE_Str) && !empty($CEA) && $CEA === "解除成功"){
        echo "<p style='color:green;'>解除成功</p>";
    }elseif(!empty($CE_Str)){
        echo "<p style='color:green;'>".$CE_Str."</p>";
    }

    ?>
    <form method="post">
    <div class="postbox" style="padding:10px;">
    <input type="text" id="ce_auth_field" name="ce_auth" style="width:100%;" value="<?php echo $CE_Code; ?>">
    </div>
    <input type="submit" name="action" class="button button-primary" value="登録">
    <input type="submit" name="action" class="button button-primary" value="解除">
    </form>
    </div>
    </div>
    </div>
    <?php
    $up_flug = false;
    if(!empty($_POST['action'])){
        if ($_POST['action'] === '登録') {
            if((isset($_POST['ce_auth']) && is_string($_POST['ce_auth']))) {
                $update_str = sanitize_text_field($_POST['ce_auth']);
                $up_flug = sanitize_text_field(CoreEdit_Authentication_Code($update_str,'register'));
                update_option('CEA_Flug',$up_flug);
                if($up_flug === '認証成功') {
                    update_option('CoreEdit_Auth',$update_str);
                }
                echo '<script>location.reload();</script>';
            }
        }elseif($_POST['action'] === '解除'){
            $update_str = sanitize_text_field($_POST['ce_auth']);
            $up_flug = sanitize_text_field(CoreEdit_Authentication_Code($update_str,'remove'));
            update_option('CEA_Flug',$up_flug);
            if($up_flug === '解除成功') {
                update_option('CoreEdit_Auth','');
            }
            echo '<script>location.reload();</script>';
        }
    }
}
/*
 CoreEdit Authentication Code
----------------------------*/
function CoreEdit_Authentication_Code($CE_Code,$action) {

    if(empty($CE_Code)) return false;

    $response = wp_remote_post(esc_url('https://coreedit.jp/auth.php'), [
        'body' => [
            'domain' => esc_url(home_url()),
            'license_code' => $CE_Code,
            'action' => $action,
        ]
    ]);

    if (is_wp_error($response)) {
        // 通信失敗
        $error_message = $response->get_error_message();
    } else {
        $data = json_decode(wp_remote_retrieve_body($response), true);
        if (!empty($data['valid']) && !empty($data['status'])) {
            return esc_attr($data['status']);
        }
    }
}
/*
 CoreEdit Footer
----------------------------*/
add_action('template_redirect', function() {
    ob_start('jflakhinvwooiskmxxx');
}, PHP_INT_MAX);
function jflakhinvwooiskmxxx($buffer) {
    $flug =  get_option('CEA_Flug','');
    if(!($flug === '認証成功')) {
        $author_string = '<div id="developed-and-distributed" style="text-align:center;">CoreEdit is developed and distributed by <a href="https://coreedit.jp" target="_blank">https://coreedit.jp</a>. This is the free version.</div>';
        if (strpos($buffer, $author_string) === false) {
            $buffer = preg_replace('/\s+id\s*=\s*"(.*?)"/i', '', $buffer);
            $buffer = preg_replace("/\s+id\s*=\s*'(.*?)'/i", '', $buffer);
            $buffer = preg_replace('/\s+class\s*=\s*"(.*?)"/i', '', $buffer);
            $buffer = preg_replace("/\s+class\s*=\s*'(.*?)'/i", '', $buffer);
        }
    }
    return $buffer;
}
/*
 template_redirect
----------------------------*/
add_action( 'template_redirect', 'ce_safe_template_redirect' );
function ce_safe_template_redirect() {
    if ( is_admin() || wp_doing_ajax() || wp_doing_cron() || defined('REST_REQUEST') && REST_REQUEST ) {
        return;
    }

    // 条件：特定のページスラッグでリダイレクト
    if ( is_page('old-page') ) {
        $target = home_url('/new-page/'); // 内部URLのみ
        wp_safe_redirect( esc_url_raw( $target ), 301 );
        exit;
    }
}