<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php get_header(); ?>
<?php if(is_active_sidebar("Hero")) : ?>
<div id="Hero" class="CoreEditSlider-wrap">
    <?php dynamic_sidebar("Hero"); ?>
</div>
<?php endif; ?>

<?php
global $CE_Settings;
for($i = 1 ; $i <= $CE_Settings['section_num'] ; $i++) {
    $column = !empty($CE_Settings['styles']['section'.$i]['_CE_Column']) ? $CE_Settings['styles']['section'.$i]['_CE_Column'] : "c1";
    if(is_active_sidebar("section".$i)) { ?>
        <div id="section<?php echo esc_attr($i); ?>" class="ce-section <?php echo esc_attr($column); ?>">
            <div class="container">
                <?php dynamic_sidebar("section".$i); ?>
            </div>
            <?php $column_num = substr($column, 1); ?>
            <style>
                #section<?php echo esc_html($i); ?>.<?php echo esc_html($column); ?> > .container {
                    display: flex;
                    justify-content: flex-start;
                    align-items: stretch;
                    flex-wrap: wrap;
                    width: 100%;
                }
                #section<?php echo esc_html($i); ?>.<?php echo esc_html($column); ?> > .container > * {
                    width: calc(100% / <?php echo esc_html($column_num); ?> - <?php if((int)$column_num > 1){echo "2%";}else{ echo "0%";} ?>);
                }
                #section<?php echo esc_html($i); ?>.<?php echo esc_html($column); ?> > .container > * {
                    margin: 10px <?php if((int)$column_num == 2){echo "1.5%";}elseif((int)$column_num == 1){echo "0";}else{echo "calc(1% + 2% / ".esc_html(((int)$column_num-2)).")";} ?> 20px <?php if((int)$column_num == 2){echo "1.5%";}elseif((int)$column_num == 1){echo "0";}else{echo "calc(1% + 2% / ".esc_html(((int)$column_num-2)).")";} ?>;
                }
                #section<?php echo esc_html($i); ?>.<?php echo esc_html($column); ?> > .container > *:nth-of-type(<?php echo esc_html($column_num); ?>n-<?php echo esc_html((int)$column_num) - 1; ?>) {
                    margin: 10px <?php if((int)$column_num == 2){echo "2%";}else{echo "0";} ?> 20px 0px;
                }
                #section<?php echo esc_html($i); ?>.<?php echo esc_html($column); ?> > .container > *:nth-of-type(<?php echo esc_html($column_num); ?>n) {
                    margin: 10px 0px 20px <?php if((int)$column_num == 2){echo "2%";}else{echo "0";} ?> ;
                }
                @media only screen and (max-width: 1024px) {
                    #section<?php echo esc_html($i); ?>.<?php echo esc_html($column); ?> > .container {
                        justify-content: center;
                    }
                    #section<?php echo esc_html($i); ?>.<?php echo esc_html($column); ?> > .container > * {
                        width: 650px;
                        max-width: 100%;
                        margin: 0px 0px 35px 0px !important;
                    }
                    #section<?php echo esc_html($i); ?>.<?php echo esc_html($column); ?> > .container > *:last-child {
                        margin-bottom: 0px !important;
                    }
                }
            </style>
        </div>
        <?php
    }
}
?>

<?php get_footer(); ?>