<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> <?php CoreEdit_schema_type(); ?> class="headerType_<?php echo Get_CE_Settings('header_type'); ?>">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width">
<link rel="canonical" href="<?php echo esc_url( 'https://' . $_SERVER["HTTP_HOST"] . parse_url( $_SERVER['REQUEST_URI'], PHP_URL_PATH ) ); ?>">
<script type="application/ld+json">
{
"@context": "https://www.schema.org/",
"@type": "WebSite",
"name": "<?php bloginfo( 'name' ); ?>",
"url": "<?php echo esc_url( home_url() ); ?>/"
}
</script>
<script type="application/ld+json">
{
"@context": "https://www.schema.org/",
"@type": "Organization",
"name": "<?php bloginfo( 'name' ); ?>",
"url": "<?php echo esc_url( home_url() ); ?>/",
"logo": "<?php if ( has_custom_logo() ) { $custom_logo_id = get_theme_mod( 'custom_logo' ); $logo = wp_get_attachment_image_src( $custom_logo_id , 'full' ); echo esc_url( $logo[0] ); } ?>",
"image": "<?php if ( has_site_icon() ) { echo esc_url( get_site_icon_url() ); } ?>",
"description": "<?php bloginfo( 'description' ); ?>"
}
</script>
<?php wp_head(); ?>
<?php wp_site_icon(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="wrapper" class="hfeed">
<header id="header">
<div id="header_container">
<div id="branding">
<div id="site-title" itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
<?php
if ( is_front_page() || is_home() || is_front_page() && is_home() ) {
echo '<h1>';
}
if ( has_custom_logo() ) {
$custom_logo_id = get_theme_mod( 'custom_logo' );
$logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );
$nologo = '';
$text_logo = '';
} elseif ( has_site_icon() ) {
$logo = get_site_icon_url();
$nologo = '';
$text_logo = '';
} else {
$logo = '';
$nologo = 'no-logo';
$text_logo = '<span class="screen-reader-text" itemprop="name">' . esc_html( get_bloginfo( 'name' ) ) . '</span>';
}
echo '<a href="' . esc_url( home_url( '/' ) ) . '" title="' . esc_attr( get_bloginfo( 'name' ) ) . '" rel="home" itemprop="url">'. $text_logo .'<span id="logo-container" itemprop="logo" itemscope itemtype="https://schema.org/ImageObject"><img src="';
if ( has_custom_logo() ) {
echo esc_url( $logo[0] );
} else {
echo esc_url( $logo );
}
echo '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" id="logo" class="' . esc_attr( $nologo ) . '" itemprop="url"></span></a>';
if ( is_front_page() || is_home() || is_front_page() && is_home() ) {
echo '</h1>';
}
?>
</div>
<div id="site-description"<?php if ( !is_single() ) { echo ' itemprop="description"'; } ?>><?php bloginfo( 'description' ); ?></div>
</div>
<div id="pc-menu" class="pc-only">
    <nav id="CoreEdit-pc" itemscope itemtype="https://schema.org/SiteNavigationElement">
        <meta itemprop="name" content="PC Menu">
        <?php wp_nav_menu( array( 'theme_location' => 'main-menu', 'link_before' => '<span itemprop="name">', 'link_after' => '</span>' ) ); ?>
    </nav>
</div>
<div id="sp-menu" class="sp-only">
    <div class="full-overlay"></div>
    <div class="sp-overlay_content spoc">
        <div class="CE_Logo__MenuBeforeWidgets celmbw">
            <div class="ld">
                <?php if(empty($text_logo)) : ?>
                    <?php
                    if (has_custom_logo()) {
                        echo '<p class="mLogo"><img src="'.esc_url($logo[0]).'" alt="'.esc_attr(get_bloginfo( 'name' )).'"></p>';
                    } else {
                        echo '<p class="mLogo"><img src="'.esc_url($logo).'" alt="'.esc_attr(get_bloginfo( 'name' )).'"></p>';
                    }
                    ?>
                <?php else : ?>
                    <p class="mLogo txt"><span><?php echo esc_html($text_logo); ?></span></p>
                <?php endif; ?>
                <?php if(!empty(get_bloginfo( 'description' ))) : echo '<span class="mDesc">'.get_bloginfo( 'description' ).'</span>'; endif; ?>
            </div>
            <?php if(is_active_sidebar("mobile-menu__before")) : ?>
                <div class="mmb">
                <?php dynamic_sidebar("mobile-menu__before"); ?>
                </div>
            <?php endif; ?>
        </div>
        <div class="CE_MobileMenu__MenuAfterWidgets cemmaw">
            <div class="cemmaw-wrap">
                <nav id="CoreEdit-mobile" itemscope itemtype="https://schema.org/SiteNavigationElement">
                    <meta itemprop="name" content="Mobile Menu">
                    <?php wp_nav_menu( array( 'theme_location' => 'mobile-menu', 'menu_class' => 'dd', 'link_before' => '<span itemprop="name">', 'link_after' => '</span>' ) ); ?>
                </nav>
                <?php if(is_active_sidebar("mobile-menu__after")) : ?>
                    <div class="mma">
                    <?php dynamic_sidebar("mobile-menu__after"); ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php if(is_active_sidebar("mobile-menu__after-bottom")) : ?>
                <div class="cemmaw-full">
                <?php dynamic_sidebar("mobile-menu__after-bottom"); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div id="mobile-toggle" style="cursor:pointer;"><span class="mt-icon first"></span><span class="mt-icon middle"></span><span class="mt-icon last"></span><span class="menu-text screen-reader-text"><?php esc_html_e( ' Menu', 'coreedit' ); ?></span></div>
</div>
<div id="search">
    <div class="full-overlay search"></div>
    <div class="search-box">
        <form method="get" class="search-form" action="<?php echo esc_url( home_url() ); ?>/"><label><span class="screen-reader-text">検索ワードを入力してください</span><input type="search" class="search-field last" placeholder="Search …" value="" name="s"><span></span></label><input type="submit" class="search-submit" value="Search"></form>
        <div id="search-close" style="cursor:pointer;"><span class="material-symbols-outlined">close</span></div>
    </div>
</div>
</div>
</header>
<div id="main-wrap">
<main id="content" class="<?php if ( !is_active_sidebar( 'sidebar-widget-area' ) ) { echo 'full-width'; } ?>">