<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php get_header(); ?>
<?php if ( have_posts() ) : ?>
    <?php global $wp_query; ?>
    <header class="header title-container">
        <div class="container">
            <h1 class="entry-title" itemprop="name"><?php printf( '検索ワード: %s (%s件)', get_search_query(), $wp_query->found_posts );  ?></h1>
            <div class="breadcrumb-wrap">
            <?php get_template_part('templates/breadcrumb'); ?>
            </div>
        </div>
    </header>
    <div class="container">
        <div class="postList">
            <?php 
            $cep_items = [
                "thumb"     =>  'y',
                "excerpt"   =>  'y',
                "term_out"  =>  'y',
                "tag_out"   =>  'y',
                "author"    =>  'n',
            ];
            ?>
            <?php while ( have_posts() ) : the_post(); ?>
                <?php get_template_part( 'templates/postList',null,$cep_items ); ?>
            <?php endwhile; ?>
            <?php get_template_part( 'nav', 'below' ); ?>
        </div>
    </div>
<?php else : ?>
    <header class="header title-container">
        <figure role="presentation" class="bg-image"><img src="<?php echo esc_url($image); ?>" alt=""></figure>
        <div class="container">
            <h1 class="entry-title" itemprop="name"><?php printf( '検索ワード: %s', get_search_query() ); ?></h1>
            <div class="breadcrumb-wrap">
            <?php get_template_part('templates/breadcrumb'); ?>
            </div>
        </div>
    </header>
    <div class="container">
        <article id="post-0" class="post no-results not-found">
            <div class="entry-content" itemprop="mainContentOfPage">
                <p>すみません、関連記事が存在しませんでした。別のワードをご利用ください。</p>
                <?php get_search_form(); ?>
            </div>
        </article>
    </div>
<?php endif; ?>
<?php get_footer(); ?>