<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php if ( is_front_page() ) : ?>
<?php endif; ?>

<?php if ( is_single() ) : ?>
    <?php if(is_active_sidebar('Single Sidebar')) { dynamic_sidebar('Single Sidebar'); } ?>
<?php endif; ?>

<?php if ( is_page() ) : ?>
    <?php global $CE_Settings; ?>
    <?php if($CE_Settings['auto_nav'] === '1') : ?>
            <?php
            global $post;
            $root_id = $post->ID;
            $ancestors = get_post_ancestors( $post->ID );
            if ( ! empty( $ancestors ) ) {
                $root_id = end( $ancestors );
            }
            $page_args = array(
                'authors'      => '',
                'child_of'     => $root_id,
                'date_format'  => get_option( 'date_format' ),
                'depth'        => 0,
                'echo'         => 0,
                'exclude'      => '',
                'include'      => '',
                'link_after'   => '',
                'link_before'  => '',
                'post_type'    => 'page',
                'post_status'  => 'publish',
                'hierarchical' => true,
                'show_date'    => '',
                'sort_column'  => 'menu_order, post_title',
                'sort_order'   => '',
                'title_li'     => '', 
                'walker'       => '',
            );
            $children_list = wp_list_pages($page_args);

            $page = get_post($root_id);
            $parent_echo['text'] = $page->post_title;
            $parent_echo['link'] = get_permalink($page->ID);
            $parent_echo['target'] = '_self';
            echo '<div id="page_autoNav" class="widget widget-container page-auto-nav">';
            echo '<h2 class="widget-title">';
            if(!empty($parent_echo['link'])) :
                echo '<a href="'.esc_url($parent_echo['link']).'" target="'.esc_attr($parent_echo['target']).'">';
            endif;
            echo esc_html($parent_echo['text']);
            if(!empty($parent_echo['link'])) :
                echo '</a>';
            endif;
            echo '</h2>';
            ?>     
            <ul class="dd">
                <?php echo wp_kses_post($children_list); ?>
            </ul>
            </div>
    <?php endif; ?>
    <?php if(is_active_sidebar('Page Sidebar')) { dynamic_sidebar('Page Sidebar'); } ?>
<?php endif; ?>

<?php if ( is_archive() ) : ?>
    <?php if(is_active_sidebar('Archive Sidebar')) { dynamic_sidebar('Archive Sidebar'); } ?>
<?php endif; ?>

<?php if ( is_search() ) : ?>
<?php endif; ?>

<?php if ( is_404() ) : ?>
<?php endif; ?>