<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php get_header(); ?>
<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
<?php
$cep1_cats = cep_cats(get_the_ID(),'');  
$cep1_tags = cep_tags(get_the_ID(),'');
$cep2_cats = cep_cats(get_the_ID(),', ');  
$cep2_tags = cep_tags(get_the_ID(),', ');
$title_label = get_post_type_object(get_post_type())->labels->singular_name;
$cat_txt = '<span class="material-symbols-outlined">folder</span>カテゴリー：';
$tag_txt = '<span class="material-symbols-outlined">sell</span>タグ：';
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <header class="header title-container">
        <div class="container">
            <p class="entry-title">
                <?php echo esc_attr($title_label); ?>
            </p>
            <?php edit_post_link(); ?>
            <div class="breadcrumb-wrap">
                <?php get_template_part('templates/breadcrumb'); ?>
            </div>
        </div>
    </header>
    <div class="container">
    <div class="main">
        <div class="entry-content" itemprop="mainEntityOfPage">
        <?php if(!empty($cep1_cats)) : ?>
        <div class="categories post_meta">
            <?php echo wp_kses_post($cep1_cats); ?>
        </div>
        <?php endif ?>
        <h1 class="entry-title" itemprop="headline"><?php the_title(); ?></h1>
        <meta itemprop="description" content="<?php echo esc_html( wp_strip_all_tags( get_the_excerpt(), true ) ); ?>">
        <div class="tags_time post_meta">
            <time class="publish"><?php the_date(); ?></time>
            <?php if(!empty($cep1_tags)) : ?>
            <div class="tags">
                <?php echo wp_kses_post($cep1_tags); ?>
            </div>
            <?php endif ?>
        </div>
        <?php if ( has_post_thumbnail() ) : ?>
            <?php the_post_thumbnail( 'full', array( 'itemprop' => 'image' ) ); ?>
        <?php endif; ?>
        <?php the_content(); ?>
        <div class="entry-links"><?php wp_link_pages(); ?></div>
        </div>
        <?php if(!empty($cep2_cats) || !empty($cep2_tags)) : ?>
            <footer class="entry-footer">
                <?php if(!empty($cep2_cats)) : ?>
                <div class="cat-links">
                    <?php echo wp_kses_post($cat_txt.$cep2_cats); ?>
                </div>
                <?php endif; ?>
                <?php if(!empty($cep2_tags)) : ?>
                <div class="tag-links">
                    <?php  ?>
                    <?php echo wp_kses_post($tag_txt.$cep2_tags); ?>
                </div>
                <?php endif; ?>
            </footer>
        <?php endif; ?>
    </div>
    <div class="sidebar">
    <?php get_sidebar(); ?>
    </div>
    </div>
</article>

<?php if ( comments_open() && !post_password_required() ) { 
echo "<div id='comments-section'><div class='container'>";
comments_template( '', true );
echo "</div></div>"; } ?>
<?php endwhile; endif; ?>
<footer class="footer">
    <div class="container">
        <?php get_template_part( 'nav', 'below-single' ); ?>
    </div>
</footer>
<?php get_footer(); ?>