<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php

$echo_item = '<ul class="breadcrumb">';
$item_tag = '<li>';
$item_tag_end = '</li>';
$echo_array['home'] = $item_tag.'<a title="HOME" href="'.esc_url( home_url('/') ).'">HOME</a>'.$item_tag_end;

if(is_home() && !is_front_page()) : 
    $echo_item .= implode('',$echo_array);
    echo wp_kses_post($echo_item.$item_tag.'<span>投稿一覧</span>'.$item_tag_end.'</ul>');

elseif(is_page()) : 
    global $post;
    $post_item = $post;
    $parent_id = 0;
    $echo_array[$post_item->ID] = $item_tag.'<span>'.get_the_title($post_item->ID).'</span>'.$item_tag_end;
    for($i = 0 ; !empty($post_item->post_parent) && $post_item->post_parent > 0 && $i < 50 ; $i++ ){
        $parent_id = $post_item->post_parent;
        $post_item = get_post($post_item->post_parent);
        $echo_array[$post_item->ID] = $item_tag.'<a title="'.get_the_title($post_item->ID).'" href="'. get_the_permalink($post_item->ID).'">'.get_the_title($post_item->ID).'</a>'.$item_tag_end;
    }
    $first_key = array_key_first($echo_array);
    $first_value = $echo_array[$first_key];
    unset($echo_array[$first_key]);
    $echo_array = array_reverse($echo_array);
    $echo_array = array_merge([$first_key => $first_value],$echo_array);
    $echo_item .= implode('',$echo_array);
    echo wp_kses_post($echo_item."</ul>");

elseif(is_singular()) : 
    global $post;
    $single_post = $post;
    $post_type = get_post_type();
    $post_type_obj = get_post_type_object( $post_type );
    $echo_array[$single_post->ID] = $item_tag.'<span>'.get_the_title($single_post->ID).'</span>'.$item_tag_end;
    if(!empty($post_type_obj)) {
        $typelink = ($post_type === 'post') ? home_url('/post') : get_post_type_archive_link($post_type);
        $echo_array[] = $item_tag.'<a title="'.$post_type_obj->labels->singular_name.'" href="'.$typelink.'">'.$post_type_obj->labels->singular_name.'</a>'.$item_tag_end;
    }
    $first_key = array_key_first($echo_array);
    $first_value = $echo_array[$first_key];
    unset($echo_array[$first_key]);
    $echo_array = array_reverse($echo_array);
    $echo_array = array_merge([$first_key => $first_value],$echo_array);
    $echo_item .= implode('',$echo_array);
    echo wp_kses_post($echo_item."</ul>");

elseif(is_tax() || is_category() || is_tag()) : 
    $query = $wp_query->get_queried_object();
    $cnt = 0;
    $term = get_term($query->term_id);
    $echo_array[$term->term_id] = $item_tag.'<span>'.$term->name.'</span>'.$item_tag_end;
    while ( $term->parent > 0 && $cnt < 100) {
        $term = get_term($term->parent);
        $echo_array[$term->term_id] = $item_tag.'<a title="'.$term->name.'" href="'.get_term_link($term->term_id).'">'.$term->name.'</a>'.$item_tag_end;
        $cnt++;
    }
    $first_key = array_key_first($echo_array);
    $first_value = $echo_array[$first_key];
    unset($echo_array[$first_key]);
    $echo_array = array_reverse($echo_array);
    $echo_array = array_merge([$first_key => $first_value],$echo_array);
    $echo_item .= implode('',$echo_array);
    echo wp_kses_post($echo_item."</ul>");

elseif(is_year() || is_month() || is_day()) : 
    if (is_year()) {
        $echo_array['year'] = $item_tag.'<span>'.get_query_var('year').'年'.'</span>'.$item_tag_end;
    } elseif (is_month()) {
        $echo_array['year_month'] = $item_tag.'<span>'.get_query_var('year').'年'.get_query_var('monthnum').'月'.'</span>'.$item_tag_end;
    }else{
        $echo_array['year_month_day'] = $item_tag.'<span>'.get_query_var('year').'年'.get_query_var('monthnum').'月'.get_query_var('day').'日'.'</span>'.$item_tag_end;
    }
    $echo_array = apply_filters('ce_breadcrumb_customizer_ymd',$echo_array);
    $echo_item .= implode('',$echo_array);
    echo wp_kses_post($echo_item);

elseif(is_post_type_archive()) : 
    $obj = get_post_type_object(get_post_type());
    $labels = get_post_type_labels($obj);
    $echo_item .= implode('',$echo_array);
    echo wp_kses_post($echo_item.$item_tag.'<span>'.$labels->name.'</span>'.$item_tag_end.'</ul>');

elseif(is_search()) : 
    $query = get_search_query();
    $echo_item .= implode('',$echo_array);
    echo wp_kses_post($echo_item.$item_tag.'<span>検索：'.$query.'</span>'.$item_tag_end.'</ul>');

elseif(is_author()) : 
    $author = get_queried_object();
    $echo_item .= implode('',$echo_array);
    echo wp_kses_post($echo_item.$item_tag.'<span>投稿者：'.$author->display_name.'</span>'.$item_tag_end.'</ul>');

elseif(is_404()) : 
    echo wp_kses_post($echo_item.$item_tag.'<span>存在しないクエリ情報です</span>'.$item_tag_end.'</ul>');


endif;

?>