<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php
$cep_items = get_query_var('cep_items');
$id = esc_attr(get_the_ID());
$ti =  esc_attr(get_the_title());//title属性等
$pu = esc_attr(get_the_date());
$li = esc_url(get_the_permalink());
$cats_list = cep_cats($id,'');
$tags_list = cep_tags($id,'');

if(!empty($cep_items)) {
    ?>
    <article id="post-<?php echo $id; ?>" class="postItems">
        <?php if($cep_items["thumb"] === 'y') : ?>
        <div class="thumb">
            <a class="thumbLink" title="<?php $ti; ?>" href="<?php echo $li; ?>">
                <?php if (has_post_thumbnail()) : ?>
                    <?php the_post_thumbnail(); ?>
                <?php else : ?>
                    <img alt="<?php echo $ti; ?>" src="<?php echo esc_url(get_stylesheet_directory_uri().'/images/thumb.webp'); ?>" />
                <?php endif; ?>
            </a>
        </div>
        <?php endif; ?>
        <div class="texts">
            <div class="metaInfo">
                <div class="publish">
                    <?php echo $pu; ?>
                </div>
                <?php if($cep_items["term_out"] === 'y' && !empty($cats_list)) : ?>
                    <div class="categories">
                        <?php echo wp_kses_post($cats_list); ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="contents">
                <header>
                    <h3 class="postTitle">
                        <a class="postLink" title="<?php $ti; ?>" href="<?php echo $li; ?>">
                            <?php echo $ti; ?>
                        </a>
                    </h3>
                </header>
                <?php if($cep_items["excerpt"] === 'y') : ?>
                <div class="postExcerpt"><?php the_excerpt(); ?></div>
                <?php endif; ?>
            </div>
            <?php if($cep_items["tag_out"] === 'y' && !empty($tags_list)) : ?>
                <div class="tags">
                    <?php  echo wp_kses_post($tags_list); ?>
                </div>
            <?php endif; ?>
            <?php if(!empty($cep_items["author"]) && $cep_items["author"] === 'y') : ?>
                <div class="author">
                    <span class="author-txt">投稿者：</span>
                    <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" class="author-link">
                        <?php the_author(); ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </article>
    <?php
} else {
?>
    <article id="post-<?php echo $id; ?>" class="postItems">
        <div class="thumb">
            <a class="thumbLink" alt="<?php echo $ti; ?>" title="<?php $ti; ?>" href="<?php echo $li; ?>">
                <?php if (has_post_thumbnail()) : ?>
                    <?php the_post_thumbnail(); ?>
                <?php else : ?>
                    <img src="<?php echo esc_url(get_stylesheet_directory_uri().'/images/thumb.webp'); ?>" />
                <?php endif; ?>
            </a>
        </div>
        <div class="texts">
            <div class="metaInfo">
                <div class="publish">
                    <?php echo $pu; ?>
                </div>
                <?php if(!empty($cats_list)) : ?>
                    <div class="categories">
                        <?php echo wp_kses_post($cats_list); ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="contents">
                <header>
                    <h3 class="postTitle">
                        <a class="postLink" title="<?php $ti; ?>" href="<?php echo $li; ?>">
                            <?php echo $ti; ?>
                        </a>
                    </h3>
                </header>
                <div class="postExcerpt"><?php the_excerpt(); ?></div>
            </div>
            <?php if(!empty($tags_list)) : ?>
                <div class="tags">
                    <?php  echo wp_kses_post($tags_list); ?>
                </div>
            <?php endif; ?>
        </div>
    </article>
<?php
}
