<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php
add_action( 'widgets_init', function () {
    register_widget( 'CoreEditImgTxt' );
});
class CoreEditImgTxt extends WP_Widget{

    public function __construct() {
        parent::__construct(
            'CoreEditImgTxt',
            'CoreEdit - 画像テキスト',
            array('description' => '画像とテキストを出力します')
        );
    }

    public function widget($args, $instance) {
        $sidebar_id   = $args['id'];
        $ceit_style = !empty($instance['ceit_style']) ? $instance['ceit_style'] : 's1';
        $widget_id = $this->id;
        $ceit_items = [
            "img" => !empty($instance['ceit_img']) ? $instance['ceit_img'] : '',
            "class" => !empty($instance['ceit_class']) ? $instance['ceit_class'] : '',
            "title_tag" => !empty($instance['ceit_title_tag']) ? $instance['ceit_title_tag'] : 'h2',
            "title" => !empty($instance['ceit_title']) ? $instance['ceit_title'] : '',
            "sub" => !empty($instance['ceit_sub']) ? $instance['ceit_sub'] : '',
            "text" => !empty($instance['ceit_text']) ? $instance['ceit_text'] : '',
            "size" => !empty($instance['ceit_size']) ? $instance['ceit_size'] : 'aspect'
        ];
        $ceit_link1_txt = !empty($instance['ceit_link1_txt']) ? $instance['ceit_link1_txt'] : '';
        $ceit_link1_url = !empty($instance['ceit_link1_url']) ? $instance['ceit_link1_url'] : '';
        $ceit_link1_target = !empty($instance['ceit_link1_target']) ? $instance['ceit_link1_target'] : '_self';
        

        if(empty($ceit_items['img']) && empty($ceit_items['title']) && empty($ceit_items['sub']) && empty($ceit_items['text']) ){return;}
        $ceit_alt = !empty($ceit_items["title"]) ? $ceit_items["title"] : (!empty($ceit_items["sub"]) ? $ceit_items["title"] : (!empty($ceit_items["text"]) ? $ceit_items["text"] : "") );
        
        $use_stag = !empty($ceit_items["title"]) ? "section" : "div";
        $use_htag = $use_stag === "section" ? "header" : "div";

        $contents = array();

        $ceit_class = !empty($ceit_items['class']) ? $ceit_items['class'].' ' : '';

        echo wp_kses_post(str_replace('class="', 'class="' .$ceit_class. ' ' .$ceit_items['size']. ' ', $args['before_widget']));
        ?>
        <<?php echo $use_stag; ?> class="CoreEditImgTxt <?php echo esc_attr($widget_id).' '.esc_attr($ceit_style); ?>">
            <div class="ceit-inner widget-inner">
                <?php if(!empty($ceit_items["img"])) { ?>
                <figure class="ceit-img"><img alt="<?php echo esc_attr($ceit_alt); ?>" src="<?php echo esc_url($ceit_items["img"]); ?>"></figure>
                <?php } ?>
                <?php if(!empty($ceit_items["title"]) || !empty($ceit_items["sub"]) || !empty($ceit_items["text"])) { ?>
                <div class="ceit-contents">
                    <?php if(!empty($ceit_items["title"]) || !empty($ceit_items["sub"])) { ?>
                    <<?php echo $use_htag; ?> class="ceit-title widget-title">
                        <?php if(!empty($ceit_items["title"])) { ?>
                        <<?php echo esc_attr($ceit_items["title_tag"]); ?>><?php echo wp_kses_post($ceit_items["title"]); ?></<?php echo esc_attr($ceit_items["title_tag"]); ?>>
                        <?php } ?>
                        <?php if(!empty($ceit_items["sub"])) { ?>
                        <div><?php echo wp_kses_post($ceit_items["sub"]); ?></div>
                        <?php } ?>
                    </<?php echo $use_htag; ?>>
                    <?php } ?>
                    <?php if(!empty($ceit_items["text"])) { ?>
                    <div class="ceit-text">
                        <?php echo wp_kses_post($ceit_items["text"]); ?>
                    </div>
                    <?php } ?>
                    <?php if(!empty($ceit_link1_txt)) { ?>
                    <div class="ce-links">
                        <a title="<?php echo esc_attr($ceit_link1_txt); ?>" class="ce-link ceit-link1" href="<?php echo esc_url($ceit_link1_url); ?>"><?php echo wp_kses_post($ceit_link1_txt); ?></a>
                    </div>
                    <?php } ?>
                        </div>
                <?php } ?>
            </div>
        </<?php echo $use_stag; ?>>
        <?php
        echo wp_kses_post($args["after_widget"]);
    }

    public function form($instance) {
        $ceit_num = !empty($instance['ceit_num']) ? $instance['ceit_num'] : 1;
        $ceit_items = [
            "img" => !empty($instance['ceit_img']) ? $instance['ceit_img'] : '',
            "class" => !empty($instance['ceit_class']) ? $instance['ceit_class'] : '',
            "title_tag" => !empty($instance['ceit_title_tag']) ? $instance['ceit_title_tag'] : 'h2',
            "title" => !empty($instance['ceit_title']) ? $instance['ceit_title'] : '',
            "sub" => !empty($instance['ceit_sub']) ? $instance['ceit_sub'] : '',
            "text" => !empty($instance['ceit_text']) ? $instance['ceit_text'] : '',
            "size" => !empty($instance['ceit_size']) ? $instance['ceit_size'] : 'aspect'
        ];
        $ceit_link1_txt = !empty($instance['ceit_link1_txt']) ? $instance['ceit_link1_txt'] : '';
        $ceit_link1_url = !empty($instance['ceit_link1_url']) ? $instance['ceit_link1_url'] : '';
        $ceit_link1_target = !empty($instance['ceit_link1_target']) ? $instance['ceit_link1_target'] : '_self';
        $ceit_link2_txt = !empty($instance['ceit_link2_txt']) ? $instance['ceit_link2_txt'] : '';
        $ceit_link2_url = !empty($instance['ceit_link2_url']) ? $instance['ceit_link2_url'] : '';
        $ceit_link2_target = !empty($instance['ceit_link2_target']) ? $instance['ceit_link2_target'] : '_self';
        $ceit_style = !empty($instance['ceit_style']) ? $instance['ceit_style'] : 's1';
        ?>
        <div class="components-placeholder ce">
            <div>
            <p class="ce-img-selecter">
                <img class="ce-image-preview" src="<?php echo esc_url($ceit_items["img"]); ?>" 
                    style="max-width:100%; height:auto; <?php echo empty($ceit_items["img"]) ? 'display:none;' : ''; ?>" />
                <button class="button ce-select-image">画像を選択</button>
                <button class="button ce-delete-image">画像を削除</button>
                <input type="hidden" class="ce-img" 
                    id="<?php echo esc_attr($this->get_field_id('ceit_img')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ceit_img')); ?>" 
                    value="<?php echo esc_attr($ceit_items["img"]); ?>" />
            </p>
            <?php if('administrator' === wp_get_current_user()->roles[0]) { ?>
            <p>
                <label>クラス:</label><br>
                <input type="text" class="ceit-class" size="25" 
                    id="<?php echo esc_attr($this->get_field_id('ceit_class')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ceit_class')); ?>" 
                    value="<?php echo esc_attr($ceit_items["class"]); ?>" />
            </p>
            <p>
                <label>タグ:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('ceit_title_tag')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('ceit_title_tag')); ?>">
                    <option value="h1" <?php selected($ceit_items["title_tag"], 'h1'); ?>>h1</option>
                    <option value="h2" <?php selected($ceit_items["title_tag"], 'h2'); ?>>h2</option>
                    <option value="h3" <?php selected($ceit_items["title_tag"], 'h3'); ?>>h3</option>
                    <option value="h4" <?php selected($ceit_items["title_tag"], 'h4'); ?>>h4</option>
                    <option value="h5" <?php selected($ceit_items["title_tag"], 'h5'); ?>>h5</option>
                </select>
            </p>
            <?php } ?>
            <p>
                <label>タイトル:</label><br>
                <input type="text" class="ceit-title" size="25" 
                    id="<?php echo esc_attr($this->get_field_id('ceit_title')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ceit_title')); ?>" 
                    value="<?php echo esc_attr($ceit_items["title"]); ?>" />
            </p>
            <p> 
                <label>サブタイトル:</label><br>
                <input type="text" class="ceit-sub" size="25" 
                    id="<?php echo esc_attr($this->get_field_id('ceit_sub')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ceit_sub')); ?>" 
                    value="<?php echo esc_attr($ceit_items["sub"]); ?>" />
            </p>
            <br>
            <div class="ce_wp-editor"> 
                <?php
                wp_editor(
                    wp_kses_post($ceit_items["text"]),
                    esc_attr($this->get_field_id('ceit_text')),
                    array(
                        'textarea_name' => esc_attr($this->get_field_name('ceit_text')),
                        'textarea_rows' => 10,
                        'quicktags'     => true,
                        'media_buttons' => true,
                        'teeny'         => true,
                        'tinymce'       => [
                            'toolbar1' => 'bold,italic,link,unlink',
                            'toolbar2' => '',
                        ],
                        'wpautop'       => false,
                        'editor_class'  => 'widefat',
                        'editor_height' => 200,
                    )
                );
                ?>
            </div>
            <br>
            </div>
            <hr>
            <div>
            <p> 
                <label>カスタムリンクテキスト:</label><br>
                <input type="text" placeholder="テキスト" 
                    id="<?php echo esc_attr($this->get_field_id('ceit_link1_txt')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ceit_link1_txt')); ?>" 
                    value="<?php echo esc_attr($ceit_link1_txt); ?>" />
            </p>
            <p>
                <label>カスタムリンクURL:</label><br>
                <input type="text" placeholder="https://example.com"  
                    id="<?php echo esc_attr($this->get_field_id('ceit_link1_url')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ceit_link1_url')); ?>" 
                    value="<?php echo esc_url($ceit_link1_url); ?>" />
            </p>
            <p> 
                <label>カスタムリンクターゲット:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('ceit_link1_target')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('ceit_link1_target')); ?>">
                    <option value="_self" <?php selected($ceit_link1_target, '_self'); ?>>現在のタブで開く</option>
                    <option value="_blank" <?php selected($ceit_link1_target, '_blank'); ?>>新しいタブで開く</option>
                </select>
            </p>
            </div>
            <hr style="margin:25px 0px 0px 0px;">
            <div style="margin-bottom:15px;">
            <p> 
                <label>スタイル:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('ceit_style')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('ceit_style')); ?>">
                    <option value="s1" <?php selected($ceit_style, 's1'); ?>>画像 上</option>
                    <option value="s2" <?php selected($ceit_style, 's2'); ?>>画像 右</option>
                    <option value="s3" <?php selected($ceit_style, 's3'); ?>>画像 左</option>
                    <option value="s4" <?php selected($ceit_style, 's4'); ?>>画像 下</option>
                </select>
            </p>
            <p>
                <label>画像サイズ:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('ceit_size')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('ceit_size')); ?>">
                    <option value="aspect" <?php selected($ceit_items['size'], 'aspect'); ?>>共通比率で表示</option>
                    <option value="origin" <?php selected($ceit_items['size'], 'origin'); ?>>オリジナル比率で表示</option>
                </select>
            </p>
            </div>
        </div>
    <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['ceit_img'] = (!empty($new_instance['ceit_img'])) ? esc_url_raw(($new_instance['ceit_img'])) : '';
        $instance['ceit_class'] = (!empty($new_instance['ceit_class'])) ? sanitize_text_field($new_instance['ceit_class']) : '';
        $instance['ceit_title_tag'] = (!empty($new_instance['ceit_title_tag'])) ? sanitize_text_field($new_instance['ceit_title_tag']) : '';
        $instance['ceit_title'] = (!empty($new_instance['ceit_title'])) ? wp_kses_post($new_instance['ceit_title']) : '';
        $instance['ceit_sub'] = (!empty($new_instance['ceit_sub'])) ? wp_kses_post($new_instance['ceit_sub']) : '';
        $instance['ceit_text'] = (!empty($new_instance['ceit_text'])) ? wp_kses_post($new_instance['ceit_text']) : '';
        $instance['ceit_link1_txt'] = (!empty($new_instance['ceit_link1_txt'])) ? wp_kses_post($new_instance['ceit_link1_txt']) : '';
        $instance['ceit_link1_url'] = (!empty($new_instance['ceit_link1_url']) && $this->is_valid_internal_fragment($new_instance['ceit_link1_url'])) ? esc_url_raw($new_instance['ceit_link1_url']) : '';
        $instance['ceit_link1_target'] = (!empty($new_instance['ceit_link1_target'])) ? sanitize_text_field($new_instance['ceit_link1_target']) : '';
        $instance['ceit_style'] = (!empty($new_instance['ceit_style'])) ? sanitize_text_field($new_instance['ceit_style']) : 's1';
        $instance['ceit_size'] = (!empty($new_instance['ceit_size'])) ? sanitize_text_field($new_instance['ceit_size']) : 'aspect';
        return $instance;
    }

    private function is_valid_internal_fragment($link) {
        if (strpos($link, '#') === 0) {
            return preg_match('/^#[a-zA-Z0-9\-_]*$/', $link);
        }
        if (preg_match('#^/[\w/-]*#\w+#', $link)) {
            return true;
        }
        $home_url = home_url();
        if (strpos($link, $home_url) === 0 && strpos($link, '#') !== false) {
            return true;
        }
        if (filter_var($link, FILTER_VALIDATE_URL)) {
            return true;
        }
        return false;
    }

}