/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
jQuery(function($){
    const targetWidgetName = 'coreedit';

    function triggerWidgetSave($widget) {
        $widget.find('.ce_wp-editor textarea.wp-editor-area').trigger('change');
    }
    function initEditorInWidget($widget) {
        $widget.find('.ce_wp-editor textarea.wp-editor-area').each(function () {
            let $textarea = $(this);
            let editorId = $textarea.attr('id');
            if (!editorId) return;
            if (wp.editor && wp.editor.remove) {
                wp.editor.remove(editorId);
            }
            setWPeditor($widget,editorId);
        });
    }
    function setWPeditor($widget,editorId){
        let settings = {
            mediaButtons: false,
            quicktags: true,
            tinymce: {
                wpautop: false,
                toolbar1: 'bold italic underline | bullist numlist | link unlink',
                toolbar2: '',
                height: 200,
                setup: function (editor) {
                    editor.on('input paste cut', function () {
                        editor.save(); 
                        triggerWidgetSave($widget);
                    });
                }
            }
        };
        setTimeout(() => {
            wp.editor.initialize(editorId, settings);
            setTimeout(function () {
                if (typeof tinymce !== 'undefined') {
                    const editor = tinymce.get(editorId);
                    if (editor) {
                        editor.show();
                    }
                }
            }, 150);
        },50);
    }
    function setObserver($widget){
        $widget.find('.ce_wp-editor textarea.wp-editor-area').each(function () {
            let $textarea = $(this);
            const target = document.querySelector('#' + $textarea.attr('id'));
            const t_iframe = tinymce.get($textarea.attr('id'));
            const editorBody = t_iframe.getBody();
            const iframeObserver = new MutationObserver(() => {
                t_iframe.save();
                triggerWidgetSave($widget);
            });
            const elementObserver = new MutationObserver((mutations) => {
                for (const mutation of mutations) {
                    if (mutation.type === 'attributes' && mutation.attributeName === 'aria-hidden') {
                        const newValue = target.getAttribute('aria-hidden');
                        if(newValue === 'false'){
                            setTimeout(()=>{
                                $textarea.css({visibility:'visible',display:'block'});
                            },100);
                        }
                    }
                }
            });
            elementObserver.observe(target, {
                attributes: true,
                attributeFilter: ['aria-hidden']
            });
            iframeObserver.observe(editorBody, { 
                childList: true, 
                subtree: true, 
                characterData: true 
            });
        });
    }
    $(document).on('widget-updated widget-added', function (event, widget) {
        initEditorInWidget($(widget));
        if(event.type === 'widget-added') {
            setTimeout(() => {
                setObserver($(widget));
            },1000);
        }
    });
    setTimeout(() => {
        $('.widget').each(function (event, widget) {
            initEditorInWidget($(widget));
            setTimeout(() => {
                setObserver($(widget));
            },1000);
        });
    },50);


    function openMediaPicker(button) {
        var frame = wp.media({
            title: '画像',
            button: { text: '画像を選択' },
            multiple: false
        });
        frame.on('select', function(){
            var attachment = frame.state().get('selection').first().toJSON();
            var container = button.closest('.ce-img-selecter');
            container.find('.ce-image-preview').attr('src', attachment.url).show();
            button.siblings('.ce-img').val(attachment.url).trigger('change');
        });
        frame.open();
    }
    function deleteMedia(button) {
        var container = button.closest('.ce-img-selecter');
        container.find('.ce-image-preview').attr('src', '').show();
        button.siblings('.ce-img').val('').trigger('change');
    }
    $(document).on('click', '.ce-select-image', function(e){
        e.preventDefault();
        openMediaPicker($(this));
    });
    $(document).on('click', '.ce-delete-image', function(e){
        e.preventDefault();
        deleteMedia($(this));
    });
    $('[name="ce_changect"]').each(function(){
        let self = $(this).attr('name');
        $(document).on('change', "[name='"+self+"']:checked", function() {
            let this_val = $(this).val();
            if(this_val == 'texts') {
                $(this).closest('.components-placeholder').children('.texts').show();
                $(this).closest('.components-placeholder').children('.buttons').hide();
            }else{
                $(this).closest('.components-placeholder').children('.texts').hide();
                $(this).closest('.components-placeholder').children('.buttons').show();
            }
        });
    });
});