<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php
if ( ! defined( 'ABSPATH' ) ) exit;

//通常ナビゲーションウィジェットを拡張
add_action( 'widgets_init', function() {
    register_widget( 'CE_Nav_Menu_Classes' );
} );
class CE_Nav_Menu_Classes extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'CoreEditWPNav',
            'CoreEdit - WPナビゲーション',
            array('description' => 'クラス指定を可能にしたWPナビゲーションウィジェットです')
        );
    }

    public function widget( $args, $instance ) {
        if ( ! empty( $instance['title'] ) ) {
            $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
        } else {
            $title = '';
        }

        $nav_menu = ! empty( $instance['nav_menu'] ) ? wp_get_nav_menu_object( $instance['nav_menu'] ) : false;
        if ( ! $nav_menu ) return;

        $container_class = $instance['container_class'] ?? '';
        $menu_class      = $instance['menu_class'] ?? '';
        $li_class        = $instance['li_class'] ?? '';
        $link_class      = $instance['link_class'] ?? '';

        $nav_args = [
            'menu'            => $nav_menu,
            'container'       => 'div',
            'container_class' => $container_class,
            'menu_class'      => $menu_class,
            'fallback_cb'     => '',
            'echo'            => false,
        ];

        // LI/A にクラス追加
        $li_filter = function( $classes, $item, $args, $depth ) use ( $li_class ) {
            if ( $li_class ) $classes[] = $li_class;
            return $classes;
        };
        $link_filter = function( $atts, $item, $args, $depth ) use ( $link_class ) {
            if ( $link_class ) $atts['class'] = trim( ($atts['class'] ?? '') . ' ' . $link_class );
            return $atts;
        };

        add_filter( 'nav_menu_css_class', $li_filter, 10, 4 );
        add_filter( 'nav_menu_link_attributes', $link_filter, 10, 4 );

        $menu_html = wp_nav_menu( $nav_args );

        remove_filter( 'nav_menu_css_class', $li_filter, 10, 4 );
        remove_filter( 'nav_menu_link_attributes', $link_filter, 10, 4 );

        echo $args['before_widget'];
        if ( $title ) echo $args['before_title'] . $title . $args['after_title'];
        echo $menu_html;
        echo $args['after_widget'];
    }

    public function form( $instance ) {
        // 既存フィールド
        $nav_menu_id = $instance['nav_menu'] ?? '';
        $title       = $instance['title'] ?? '';
        $container   = $instance['container'] ?? 'div';
        $container_class = $instance['container_class'] ?? '';
        $menu_class      = $instance['menu_class'] ?? '';
        $li_class        = $instance['li_class'] ?? '';
        $link_class      = $instance['link_class'] ?? '';
        ?>
        <p>
            <label>タイトル:</label>
            <input class="widefat" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label>メニュー選択:</label>
            <select class="widefat" name="<?php echo esc_attr($this->get_field_name('nav_menu')); ?>">
                <option value="0">選択してください</option>
                <?php
                $menus = wp_get_nav_menus();
                foreach ($menus as $menu) {
                    printf('<option value="%s"%s>%s</option>',
                        esc_attr($menu->term_id),
                        selected($menu->term_id, $nav_menu_id, false),
                        esc_html($menu->name)
                    );
                }
                ?>
            </select>
        </p>
        <p>
            <label>Container class:</label>
            <input class="widefat" name="<?php echo esc_attr($this->get_field_name('container_class')); ?>" type="text" value="<?php echo esc_attr($container_class); ?>" />
        </p>
        <p>
            <label>UL class:</label>
            <input class="widefat" name="<?php echo esc_attr($this->get_field_name('menu_class')); ?>" type="text" value="<?php echo esc_attr($menu_class); ?>" />
        </p>
        <p>
            <label>LI class:</label>
            <input class="widefat" name="<?php echo esc_attr($this->get_field_name('li_class')); ?>" type="text" value="<?php echo esc_attr($li_class); ?>" />
        </p>
        <p>
            <label>A class:</label>
            <input class="widefat" name="<?php echo esc_attr($this->get_field_name('link_class')); ?>" type="text" value="<?php echo esc_attr($link_class); ?>" />
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = [];
        $instance['title']           = wp_kses_post( $new_instance['title'] ?? '' );
        $instance['nav_menu']        = absint( $new_instance['nav_menu'] ?? 0 );
        $instance['container_class'] = sanitize_text_field( $new_instance['container_class'] ?? '' );
        $instance['menu_class']      = sanitize_text_field( $new_instance['menu_class'] ?? '' );
        $instance['li_class']        = sanitize_text_field( $new_instance['li_class'] ?? '' );
        $instance['link_class']      = sanitize_text_field( $new_instance['link_class'] ?? '' );
        return $instance;
    }
}