/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
jQuery(document).ready(function($) {
    $(document).on('change', '[id^="widget-coreeditpost"][id$="cep_type"]', function() {
        let parent_val = $(this).val();
        let self = this;
        $.ajax({
            url: cePost.ajax_url,
            type: 'POST',
            data: {
                action: 'cep_taxs',
                parent_value: parent_val,
                nonce: cePost.nonce,
            },
            success: function(response) {
                $(self).parent('p').next('p').find('[id^="widget-coreeditpost"][id$="cep_term"]').html(response);
            },
            error: function(xhr, status, error) {
                console.error('Ajax Error:', error);
            }
            
        });
    });
});