<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php
add_action( 'widgets_init', function () {
    register_widget( 'CoreEditPost' );
});
class CoreEditPost extends WP_Widget{

    public function __construct() {
        parent::__construct(
            'CoreEditPost',
            'CoreEdit - 投稿',
            array('description' => '任意の投稿を出力します。')
        );
    }

    public function widget($args, $instance) {
        $sidebar_id   = $args['id'];
        $cep_style = !empty($instance['cep_style']) ? $instance['cep_style'] : 's1';
        $widget_id = $this->id;
        $cep_items = [
            "widget" => true,
            "class" => !empty($instance['cep_class']) ? $instance['cep_class'] : '',
            "type" => !empty($instance['cep_type']) ? $instance['cep_type'] : 'post',
            "term" => !empty($instance['cep_term']) ? $instance['cep_term'] : array(),
            "thumb" => (!empty($instance['cep_thumb']) && $instance['cep_thumb'] === 'y' ) ? 'y' : 'n',
            "excerpt" => (!empty($instance['cep_excerpt']) && $instance['cep_excerpt'] === 'y' ) ? 'y' : 'n',
            "author" =>  (!empty($instance['cep_author']) && $instance['cep_author'] === 'y' ) ? 'y' : 'n',
            "term_out" =>  (!empty($instance['cep_term_out']) && $instance['cep_term_out'] === 'y' ) ? 'y' : 'n',
            "tag_out" =>  (!empty($instance['cep_tag_out']) && $instance['cep_tag_out'] === 'y' ) ? 'y' : 'n',
            "per" => !empty($instance['cep_per']) ? $instance['cep_per'] : get_option('posts_per_page'),
        ];
        $cep_link1_txt = !empty($instance['cep_link1_txt']) ? $instance['cep_link1_txt'] : '';
        $cep_link1_url = !empty($instance['cep_link1_url']) ? $instance['cep_link1_url'] : '';
        $cep_link1_target = !empty($instance['cep_link1_target']) ? $instance['cep_link1_target'] : '_self';

        $tax_args = array();
        $query_args = array();
        $taxonomies = get_object_taxonomies($cep_items['type'], 'objects');
        foreach ($taxonomies as $key => $tax) {
            if(empty($cep_items['term'][$key])) {continue;}
            $tax_args[$key] = array(
                'taxonomy' => $key,
                'field'    => 'slug',
                'terms'    => $cep_items['term'][$key],
                'operator' => 'IN',
            );
        }
        if (!empty($tax_args)) {
            $query_args = array(
                'post_type' => $cep_items['type'],
                'tax_query' => array(
                    'relation' => 'OR',
                ),
                'post_status'    => 'publish',
                'posts_per_page' => $cep_items['per'],
            );
            $query_args['tax_query'] += array_filter($tax_args, function($value) {
                return is_array($value);
            });
        }else{
            $query_args = array(
                'post_type' => $cep_items['type'],
                'post_status'    => 'publish',
                'posts_per_page' => $cep_items['per'],
            );
        }

        $query = new WP_Query($query_args);
        $cep_class = !empty($cep_items['class']) ? $cep_items['class'].' ' : '';
        if(!empty($query) && !is_wp_error($query)) {
            set_query_var('cep_items', $cep_items);
            echo wp_kses_post(str_replace('class="', 'class="' .$cep_class, $args['before_widget']));
            ?>
            <article class="CoreEditPost <?php echo esc_attr($widget_id).' '.esc_attr($cep_style); ?>">
                <div class="cep-inner widget-inner postList">
                    <?php while ($query->have_posts()) : $query->the_post(); ?>
                    <?php get_template_part("templates/postList"); ?>
                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>
                </div>
                <?php if(!empty($cep_link1_txt)) { ?>
                <div class="ce-links">
                    <a title="<?php echo esc_attr($cep_link1_txt); ?>" class="ce-link cep-link1" href="<?php echo esc_url($cep_link1_url); ?>"><?php echo wp_kses_post($cep_link1_txt); ?></a>
                </div>
                <?php } ?> 
            </article>
            <?php
            echo wp_kses_post($args["after_widget"]);
        }
    }
    public function form($instance) {
        $cep_items = [
            "class" => !empty($instance['cep_class']) ? $instance['cep_class'] : '',
            "type" => !empty($instance['cep_type']) ? $instance['cep_type'] : 'post',
            "term" => !empty($instance['cep_term']) ? $instance['cep_term'] : array(),
            "thumb" => (!empty($instance['cep_thumb']) && $instance['cep_thumb'] === 'y' ) ? 'y' : 'n',
            "excerpt" => (!empty($instance['cep_excerpt']) && $instance['cep_excerpt'] === 'y' ) ? 'y' : 'n',
            "author" =>  (!empty($instance['cep_author']) && $instance['cep_author'] === 'y' ) ? 'y' : 'n',
            "term_out" =>  (!empty($instance['cep_term_out']) && $instance['cep_term_out'] === 'y' ) ? 'y' : 'n',
            "tag_out" =>  (!empty($instance['cep_tag_out']) && $instance['cep_tag_out'] === 'y' ) ? 'y' : 'n',
            "per" => !empty($instance['cep_per']) ? $instance['cep_per'] : get_option('posts_per_page'),
        ];
        $cep_link1_txt = !empty($instance['cep_link1_txt']) ? $instance['cep_link1_txt'] : '';
        $cep_link1_url = !empty($instance['cep_link1_url']) ? $instance['cep_link1_url'] : '';
        $cep_link1_target = !empty($instance['cep_link1_target']) ? $instance['cep_link1_target'] : '_self';
        $cep_style = !empty($instance['cep_style']) ? $instance['cep_style'] : 's1';
        ?>
        <div class="components-placeholder ce">

            <div>
            <?php if('administrator' === wp_get_current_user()->roles[0]) { ?>
            <p>
                <label>クラス:</label><br>
                <input type="text" class="cep-class" size="25" 
                    id="<?php echo esc_attr($this->get_field_id('cep_class')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('cep_class')); ?>" 
                    value="<?php echo esc_attr($cep_items["class"]); ?>" />
            </p>
            <?php } ?>
            <p>
                <label>投稿タイプ:</label>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('cep_type')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('cep_type')); ?>">
                    <?php
                    $exclude_types = ['page', 'attachment', 'revision', 'nav_menu_item', 'custom_css', 'customize_changeset', 'oembed_cache', 'wp_block'];
                    $post_types = get_post_types(['public' => true], 'objects');
                    foreach ($post_types as $slug => $post_type) {
                        if (!in_array($post_type->name, $exclude_types)) {
                        ?><option value="<?php echo esc_attr($slug); ?>" <?php selected($cep_items["type"], $slug); ?>><?php echo esc_html($post_type->label); ?></option><?php
                        }
                    }
                    ?>
                </select>
            </p>
            <?php
            $post_type = $cep_items["type"];
            $taxonomies = get_object_taxonomies($post_type, 'objects');
            ?>
            <p>
                <label>絞り込み:</label><br>
                <select multiple class="widefat" id="<?php echo esc_attr($this->get_field_id('cep_term')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('cep_term')); ?>[]">
                        <?php
                        foreach ($taxonomies as $key => $tax) {
                            $terms = get_terms(['taxonomy' => $key,'hide_empty' => false,]);
                            if(!is_wp_error($terms)) {
                                foreach ($terms as $term) {
                                    if(empty($cep_items["term"][$key])) {$cep_items["term"][$key] = array();}
                                    ?><option value="<?php echo esc_attr($key.'-'.$term->slug); ?>" <?php selected(in_array($term->slug, $cep_items["term"][$key])); ?>><?php echo esc_html($term->name); ?>(<?php echo esc_html($key); ?>)</option><?php
                                }
                            }
                        }
                        ?>
                </select>
            </p>
            <p>
            <label>表示する項目:</label><br>
            <?php
            if(post_type_supports($post_type, 'thumbnail')) {
            ?>
                <input type='checkbox' id='<?php echo esc_attr($this->get_field_id('cep_thumb')); ?>' 
                    name='<?php echo esc_attr($this->get_field_name('cep_thumb')); ?>' 
                    value='y' <?php checked( $cep_items["thumb"] , 'y' ); ?> />
                <label>サムネイル</label><br>
            <?php } ?>
                <input type='checkbox' id='<?php echo esc_attr($this->get_field_id('cep_excerpt')); ?>' 
                    name='<?php echo esc_attr($this->get_field_name('cep_excerpt')); ?>' 
                    value='y' <?php checked( $cep_items["excerpt"] , 'y' ); ?> />
                <label>抜粋</label><br>
                <input type='checkbox' id='<?php echo esc_attr($this->get_field_id('cep_author')); ?>' 
                    name='<?php echo esc_attr($this->get_field_name('cep_author')); ?>' 
                    value='y' <?php checked( $cep_items["author"] , 'y' ); ?> />
                <label>投稿者</label><br>
                <input type='checkbox' id='<?php echo esc_attr($this->get_field_id('cep_term_out')); ?>' 
                    name='<?php echo esc_attr($this->get_field_name('cep_term_out')); ?>' 
                    value='y' <?php checked( $cep_items["term_out"] , 'y' ); ?> />
                <label>カテゴリー</label><br>
                <input type='checkbox' id='<?php echo esc_attr($this->get_field_id('cep_tag_out')); ?>' 
                    name='<?php echo esc_attr($this->get_field_name('cep_tag_out')); ?>' 
                    value='y' <?php checked( $cep_items["tag_out"] , 'y' ); ?> />
                <label>タグ</label><br>
            </p>
            <p>
                <label>最大投稿数:</label>
                <input type='number' id='<?php echo esc_attr($this->get_field_id('cep_per')); ?>' 
                    name='<?php echo esc_attr($this->get_field_name('cep_per')); ?>' 
                    value='<?php echo $cep_items["per"]; ?>' min='1' max='100' step='1' />
            </p>
            </div>

            <hr style="margin-top:20px;">

            <div>
            <p> 
                <label>カスタムリンクテキスト:</label><br>
                <input type="text" placeholder="テキスト" 
                    id="<?php echo $this->get_field_id('cep_link1_txt'); ?>" 
                    name="<?php echo $this->get_field_name('cep_link1_txt'); ?>" 
                    value="<?php echo wp_kses_post($cep_link1_txt); ?>" />
            </p>
            <p>
                <label>カスタムリンクURL:</label><br>
                <input type="text" placeholder="https://example.com"  
                    id="<?php echo $this->get_field_id('cep_link1_url'); ?>" 
                    name="<?php echo $this->get_field_name('cep_link1_url'); ?>" 
                    value="<?php echo esc_url($cep_link1_url); ?>" />
            </p>
            <p> 
                <label>カスタムリンクターゲット:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('cep_link1_target')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('cep_link1_target')); ?>">
                    <option value="_self" <?php selected($cep_link1_target, '_self'); ?>>現在のタブで開く</option>
                    <option value="_blank" <?php selected($cep_link1_target, '_blank'); ?>>新しいタブで開く</option>
                </select>
            </p>
            </div>

            <hr style="margin:25px 0px 0px 0px;">
            <div style="margin-bottom:15px;">
            <p> 
                <label>スタイル:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('cep_style')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('cep_style')); ?>">
                    <option value="s1" <?php selected($cep_style, 's1'); ?>>リスト</option>
                    <option value="s2" <?php selected($cep_style, 's2'); ?>>グリッド</option>
                </select>
            </p>
            </div>
        </div>
    <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['cep_class'] = (!empty($new_instance['cep_class'])) ? sanitize_text_field($new_instance['cep_class']) : '';
        $instance['cep_type'] = !empty($new_instance['cep_type']) ? wp_strip_all_tags($new_instance['cep_type']) : 'post';
        $instance['cep_term'] = (!empty($instance['cep_type']) && !empty($new_instance['cep_term'])) ? (array)($this->cep_query_sub($instance['cep_type'],$new_instance['cep_term'])) : array();
        $instance['cep_thumb'] = (!empty($new_instance['cep_thumb']) && $new_instance['cep_thumb'] === 'y' ) ? 'y' : 'n';
        $instance['cep_excerpt'] = (!empty($new_instance['cep_excerpt']) && $new_instance['cep_excerpt'] === 'y' ) ? 'y' : 'n';
        $instance['cep_author'] = (!empty($new_instance['cep_author']) && $new_instance['cep_author'] === 'y' ) ? 'y' : 'n';
        $instance['cep_term_out'] = (!empty($new_instance['cep_term_out']) && $new_instance['cep_term_out'] === 'y' ) ? 'y' : 'n';
        $instance['cep_tag_out'] = (!empty($new_instance['cep_tag_out']) && $new_instance['cep_tag_out'] === 'y' ) ? 'y' : 'n';
        $instance['cep_per'] = !empty($new_instance['cep_per']) ? intval($new_instance['cep_per']) : intval(get_option('posts_per_page'));
        $instance['cep_link1_txt'] = (!empty($new_instance['cep_link1_txt'])) ? wp_kses_post($new_instance['cep_link1_txt']) : '';
        $instance['cep_link1_url'] = (!empty($new_instance['cep_link1_url']) && $this->is_valid_internal_fragment($new_instance['cep_link1_url'])) ? $new_instance['cep_link1_url'] : '';
        $instance['cep_link1_target'] = (!empty($new_instance['cep_link1_target'])) ? wp_kses_post($new_instance['cep_link1_target']) : '';
        $instance['cep_style'] = (!empty($new_instance['cep_style'])) ? sanitize_text_field($new_instance['cep_style']) : 's1';
        return $instance;
    }

    private function cep_query_sub($type,$tax_terms) {
        $update_data = array();
        $taxonomies = get_object_taxonomies($type, 'objects');
        foreach($taxonomies as $key => $tax) {
            $dmp = array_filter($tax_terms, function($tax_term) use ($key) {
                $prefix = $key.'-';
                return strpos($tax_term, $prefix) === 0;
            });
            $term = array_map(function($item) use ($key) {
                $prefix = $key.'-';
                if(strpos($item, $prefix) === 0) {
                    return substr($item, strlen($prefix));
                }
            }, $dmp);
            $update_data[$key] = $term;
        }
        return $update_data;
    }

    private function is_valid_internal_fragment($link) {
        if (strpos($link, '#') === 0) {
            return preg_match('/^#[a-zA-Z0-9\-_]*$/', $link);
        }
        if (preg_match('#^/[\w/-]*#\w+#', $link)) {
            return true;
        }
        $home_url = home_url();
        if (strpos($link, $home_url) === 0 && strpos($link, '#') !== false) {
            return true;
        }
        if (filter_var($link, FILTER_VALIDATE_URL)) {
            return true;
        }
        return false;
    }

}
add_action('admin_enqueue_scripts', function($hook) {
    if ($hook === 'widgets.php') {
        wp_enqueue_script('cep-script', get_template_directory_uri() . '/widgets/post/post.js', array('jquery'), null, true);
        wp_localize_script('cep-script', 'cePost', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('ce_post_nonce'),
        ]);
    }
});
add_action('wp_ajax_cep_taxs', 'cep_taxs_callback');
function cep_taxs_callback() {
    check_ajax_referer('ce_post_nonce', 'nonce');
    $parent_val = sanitize_text_field($_POST['parent_value']);
    $taxonomies = get_object_taxonomies($parent_val, 'objects');
    if(!empty($taxonomies)) {
        foreach ($taxonomies as $key => $tax) {
            $terms = get_terms(['taxonomy' => $key,'hide_empty' => false,]);
            if(!is_wp_error($terms)) {
                foreach ($terms as $term) {
                    ?><option value="<?php echo esc_attr($key.'-'.$term->slug); ?>"><?php echo esc_html($term->name); ?>(<?php echo esc_html($key); ?>)</option><?php
                }
            }
        }
    }
    wp_die();
}