/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
jQuery(function($){
    let target = $(".CoreEditSlider.ces-active");
    target.children(".ces-inner").children(".ces-item").hide();
    target.append("<span class='ces-prev ces-a-nav''><span></span></span><span class='ces-next ces-a-nav'><span></span></span><div class='ces-d-nav'></div>");
    target.each(function(){

        let item = {
            "anime" : "slide",
            "duration" : 8000,//変更可 スライドの表示時間 ミリ秒
            "speed" : 700,//変更可 スライドの切り替わり時間 500ミリ秒より多く
            "elem" : this,
            "length" : $(this).children(".ces-inner").children(".ces-item").length,
            "current" : 0,
            "move" : null,
        };

        let dot_nav = "<span class='ces-dot'></span>";
        let dot_elem = "";
        for(let i = 0 ; i < item["length"] ; i++) {
            dot_elem += dot_nav;
        }
        $(item["elem"]).children(".ces-d-nav").append(dot_elem);

        if(item["anime"] === "slide") {
            ces_slide(item);
        }
    });

    function ces_slide(item) {

        let dummy = $(item["elem"]).children(".ces-inner").children(".ces-item");
        dummy.clone().appendTo($(item["elem"]).children(".ces-inner"));
        dummy.clone().appendTo($(item["elem"]).children(".ces-inner"));
        item["current"] = item["length"];
        item["length"] = $(item["elem"]).children(".ces-inner").children(".ces-item").length;
        $(item["elem"]).children(".ces-inner").children(".ces-item").eq(item["current"]).addClass("ces-show");
        setnav();

        let resize_width = $(item["elem"]).outerWidth();

        //sp-menu 対策
        let spmn = document.getElementById("sp-menu");
        let spmd = $("#sp-menu");
        const observer = new MutationObserver(() => {
            if(spmd.hasClass("full-active")){
                resize_width = $(item["elem"]).outerWidth();
            }
        });
        observer.observe(spmn, {
            attributes: true,
            attributeFilter: ['class']
        });

        $(window).on("resize",function(){
            resize_width = $(item["elem"]).outerWidth();
            setpos();
        });

        let isClickable = true;
        $(item["elem"]).children(".ces-d-nav").on("click",".ces-dot",function(){
            if (!isClickable) return;
            let mynum = $(this).index();
            if(mynum != item["current"] % (item["length"] / 3)) {
                if(mynum < item["current"] % (item["length"] / 3)) {
                    let sa = item["current"] % (item["length"] / 3) - mynum;
                    flugInterval(false);
                    isClickable = false;
                    for(let i = 0 ; i < sa ; i++) {
                        cePrev();
                    }
                    setTimeout(function(){
                        flugInterval(true);
                        isClickable = true;
                    },item["speed"] + 500);
                }else{
                    let sa = mynum - item["current"] % (item["length"] / 3);
                    flugInterval(false);
                    isClickable = false;
                    for(let i = 0 ; i < sa ; i++) {
                        ceNext();
                    }
                    setTimeout(function(){
                        flugInterval(true);
                        isClickable = true;
                    },item["speed"] + 500);
                }
            }
        });
        $(item["elem"]).children(".ces-prev").on("click",function(){
            if (!isClickable) return;
            flugInterval(false);
            isClickable = false;
            cePrev();
            setTimeout(function(){
                flugInterval(true);
                isClickable = true;
            },item["speed"] + 500);
        });
        $(item["elem"]).children(".ces-next").on("click",function(){
            if (!isClickable) return;
            flugInterval(false);
            isClickable = false;
            ceNext();
            setTimeout(function(){
                flugInterval(true);
                isClickable = true;
            },item["speed"] + 500);
        });


        $(item["elem"]).css({
            "max-width" : "100%",
            "min-width" : "100%",
            "width" : "100%",
            "overflow" : "hidden",
        });
        $(item["elem"]).children(".ces-inner").css({
            "max-width" : item["length"]+"00%",
            "min-width" : item["length"]+"00%",
            "width" : item["length"]+"00%",
            "display" : "flex",
            "flex-wrap" : "nowrap",
            "justify-content" : "flex-start",
            "position" : "relative",
            "transform":"translateX(-"+(item["current"])*resize_width+"px)",
            "transition" : "transform "+item["speed"]+"ms ease-in-out",
        });
        $(item["elem"]).children(".ces-inner").children(".ces-item").css({
            "max-width" : "calc(100%/"+item["length"]+")",
            "min-width" : "calc(100%/"+item["length"]+")",
            "width" : "calc(100%/"+item["length"]+")",
        });

        $(item["elem"]).children(".ces-inner").children(".ces-item").fadeIn(0);

        flugInterval(true);

        function startInterval() {
            item["move"] = setInterval(function(){
                ceNext();
            },item["duration"]);
        }
        function flugInterval(move_flug) {
            if(move_flug) {
                startInterval();
            } else {
                clearInterval(item["move"]);
            }
        }
        function ceNext(){
            let old = item["current"];
            if(item["current"] < item["length"]) {
                item["current"]++;
            }
            $(item["elem"]).children(".ces-inner").children(".ces-item").eq(item["current"]).addClass("ces-show");
            $(item["elem"]).children(".ces-inner").children(".ces-item").eq(old).removeClass("ces-show");
            setpos();
            schange();
            setnav();
        }
        function cePrev(){
            let old = item["current"];
            if(item["current"] > 0) {
                item["current"]--;
            }else{
                item["current"] = (item["length"] / 3 * 2) - 1;
            }
            $(item["elem"]).children(".ces-inner").children(".ces-item").eq(item["current"]).addClass("ces-show");
            $(item["elem"]).children(".ces-inner").children(".ces-item").eq(old).removeClass("ces-show");
            setpos();
            schange();
            setnav();
        }
        function schange() {
            if(item["current"] >= item["length"] / 3 * 2) {
                setTimeout(function(){
                    $(item["elem"]).children(".ces-inner").children(".ces-item").eq(item["current"]).removeClass("ces-show");
                    item["current"] = item["current"] - item["length"] / 3;
                    $(item["elem"]).children(".ces-inner").children(".ces-item").eq(item["current"]).addClass("ces-show");
                    $(item["elem"]).children(".ces-inner").css({
                        "transition" : "none",
                    });
                    setTimeout(function(){
                        setpos();
                        setTimeout(function(){
                            $(item["elem"]).children(".ces-inner").css({
                                "transition" : "transform "+item["speed"]+"ms ease-in-out",
                            });
                        },100);
                    },100);
                },item["speed"]+100);
            }else if(item["current"] < item["length"] / 3){
                setTimeout(function(){
                    $(item["elem"]).children(".ces-inner").children(".ces-item").eq(item["current"]).removeClass("ces-show");
                    item["current"] = item["current"] + item["length"] / 3;
                    $(item["elem"]).children(".ces-inner").children(".ces-item").eq(item["current"]).addClass("ces-show");
                    $(item["elem"]).children(".ces-inner").css({
                        "transition" : "none",
                    });
                    setTimeout(function(){
                        setpos();
                        setTimeout(function(){
                            $(item["elem"]).children(".ces-inner").css({
                                "transition" : "transform "+item["speed"]+"ms ease-in-out",
                            });
                        },100);
                    },100);
                },item["speed"]+100);
            }
        }
        function setpos() {
            $(item["elem"]).children(".ces-inner").css({
                "transform" : "translateX(-"+(item["current"])*resize_width+"px)",
            });
        }
        function setnav() {
            $(item["elem"]).children(".ces-d-nav").children(".ces-dot").removeClass("ces-active");
            if(item["current"] >= item["length"] / 3 * 2) {
                $(item["elem"]).children(".ces-d-nav").children(".ces-dot").eq(item["current"] - item["length"] / 3 * 2).addClass("ces-active");
            } else if(item["current"] < item["length"] / 3) {
                $(item["elem"]).children(".ces-d-nav").children(".ces-dot").eq(item["current"]).addClass("ces-active");
            } else {
                $(item["elem"]).children(".ces-d-nav").children(".ces-dot").eq(item["current"] - item["length"] / 3).addClass("ces-active");
            }
        }
    }
});