/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
jQuery(function($){
    function CE_SetAccordion() {
        $('[id*="coreeditslider"] .ces-accordion').each(function() {
            let container = $(this);
            container.find('.toggle-settings').each(function(){
                let btn = $(this);
                let mess = btn.text();
                let mess2 = mess.replace("▼", "▲");
                btn.off('click').on('click', function(e) {
                    e.preventDefault();
                    btn.next('.accordion-content').slideToggle();
                    let m2 = $(this).text().includes("▼") ? mess2 : mess;
                    btn.text(m2);
                });
            });
        });
    }
    CE_SetAccordion();
    $(document).on('change', '[id*="coreeditslider"][id$="ces_num"]', function() {
        let widget_id = $(this).closest('.widget').attr('id');
        let parent_val = $(this).val();
        let self = this;
        
        $.ajax({
            url: ceSlide.ajax_url,
            type: 'POST',
            data: {
                action: 'ces_accordion',
                parent_value: parent_val,
                widget_id: widget_id,
                nonce: ceSlide.nonce,
            },
            success: function(response) {
                $(self).closest('.widget').find('div.ces-accordion').html('');
                $(self).closest('.widget').find('div.ces-accordion').html(response);
                $(self).closest('.widget').find('div.ces-accordion').each(function(){
                    let container = $(this);
                    container.find('.toggle-settings').each(function(){
                        let btn = $(this);
                        let mess = btn.text();
                        let mess2 = mess.replace("▼", "▲");
                        btn.off('click').on('click', function(e) {
                            e.preventDefault();
                            btn.next('.accordion-content').slideToggle();
                            let m2 = $(this).text().includes("▼") ? mess2 : mess;
                            btn.text(m2);
                        });
                    });
                });
            },
            error: function(xhr, status, error) {
                console.error('Ajax Error:', error);
            }
            
        });
    });
    $(document).on('widget-added widget-updated', function (e, widget) {
        setTimeout(function () {
            CE_SetAccordion();
        }, 300);
    });
});