<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php
add_action( 'widgets_init', function () {
    register_widget( 'CoreEditSlider' );
});
class CoreEditSlider extends WP_Widget{

    public function __construct() {
        parent::__construct(
            'CoreEditSlider',
            'CoreEdit - スライド',
            array(
                'description' => '簡易的なスライドを出力します',
            )
        );
    }

    public function widget($args, $instance) {
        $sidebar_id   = $args['id'];
        $ces_class = !empty($instance['ces_class']) ? $instance['ces_class'].' ' : '';
        $ces_style = !empty($instance['ces_style']) ? $instance['ces_style'] : 's1';
        $widget_id = $this->id;
        $ces_num = !empty($instance['ces_num']) ? $instance['ces_num'] : 1;
        $ces_slide = $ces_num > 1 ? "ces-active" : "ces-deactive";
        $ces_title = !empty($instance['ces_title']) ? $instance['ces_title'] : '';
        $ces_sub = !empty($instance['ces_sub']) ? $instance['ces_sub'] : '';
        $ces_text = !empty($instance['ces_text']) ? $instance['ces_text'] : '';
        $ces_link1_txt = !empty($instance['ces_link1_txt']) ? $instance['ces_link1_txt'] : '';
        $ces_link1_url = !empty($instance['ces_link1_url']) ? $instance['ces_link1_url'] : '';
        $ces_link1_target = !empty($instance['ces_link1_target']) ? $instance['ces_link1_target'] : '_self';

        $use_stag = !empty($ces_title) ? "section" : "div";
        $use_htag = $use_stag === "section" ? "header" : "div";

        echo wp_kses_post(str_replace('class="', 'class="' .$ces_class, $args['before_widget']));
        ?>
        <article class="CoreEditSlider_wrap">
            <div class="CoreEditSlider <?php echo esc_attr($ces_slide); ?> <?php echo esc_attr($widget_id).' '.esc_attr($ces_style); ?>">
                <div class="ces-inner">
                    <?php
                    for( $i = 0 ; $i < $ces_num ; $i++ ) {
                        $ces_items = [];
                        $ces_items["img"] = !empty($instance['ces_img'.$i]) ? $instance['ces_img'.$i] : '';
                        if(empty($ces_items)){continue;}
                    ?>
                        <div class="ces-item ces-item_<?php echo esc_attr($i); ?>">
                            <figure class="cesi-back" role="presentation">
                                <?php if($ces_items["img"] !== '') { ?>
                                <img alt="" src="<?php echo esc_url($ces_items["img"]); ?>">
                                <?php } ?>
                            </figure>
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </div>
            <<?php echo $use_stag; ?> class="ces-texts ces-inner">
                <div class="ces-container">
                    <?php if(!empty($ces_title) || !empty($ces_sub)) { ?>
                        <<?php echo $use_htag; ?> class="ces-title">
                            <?php if(!empty($ces_title)) { ?>
                            <h2 class="widget-title"><?php echo wp_kses_post($ces_title); ?></h2>
                            <?php } ?>
                            <?php if(!empty($ces_sub)) { ?>
                            <div><?php echo wp_kses_post($ces_sub); ?></div>
                            <?php } ?>
                        </<?php echo $use_htag; ?>>
                    <?php } ?>
                    <?php if(!empty($ces_text)) { ?>
                        <div class="ces-text">
                            <div><?php echo wp_kses_post($ces_text); ?></div>
                        </div>
                    <?php } ?>
                    <?php if(!empty($ces_link1_txt)) { ?>
                    <div class="ce-links">
                        <a title="<?php echo esc_attr($ces_link1_txt); ?>" class="ce-link ces-link1" href="<?php echo esc_url($ces_link1_url); ?>"><?php echo esc_html($ces_link1_txt); ?></a>
                    </div>
                    <?php } ?>  
                </div>
            </<?php echo $use_stag; ?>>
        </article>
        <?php
        echo $args["after_widget"];
    }

    public function form($instance) {
        $ces_num = !empty($instance['ces_num']) ? $instance['ces_num'] : 1;
        $ces_class = !empty($instance['ces_class']) ? $instance['ces_class'].' ' : '';
        $ces_title = !empty($instance['ces_title']) ? $instance['ces_title'] : '';
        $ces_sub = !empty($instance['ces_sub']) ? $instance['ces_sub'] : '';
        $ces_text = !empty($instance['ces_text']) ? $instance['ces_text'] : '';
        $ces_link1_txt = !empty($instance['ces_link1_txt']) ? $instance['ces_link1_txt'] : '';
        $ces_link1_url = !empty($instance['ces_link1_url']) ? $instance['ces_link1_url'] : '';
        $ces_link1_target = !empty($instance['ces_link1_target']) ? $instance['ces_link1_target'] : '_self';
        $ces_style = !empty($instance['ces_style']) ? $instance['ces_style'] : 's1';
        ?>
        <div class="components-placeholder ce">

            <div>
            <?php if('administrator' === wp_get_current_user()->roles[0]) { ?>
            <p>
                <label>クラス:</label><br>
                <input type="text" class="cep-class" size="25" 
                    id="<?php echo esc_attr($this->get_field_id('ces_class')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ces_class')); ?>" 
                    value="<?php echo esc_attr($ces_class); ?>" />
            </p>
            <?php } ?>
            <p>
                <label>タイトル:</label><br>
                <input type="text" class="ces-title" size="25" 
                    id="<?php echo esc_attr($this->get_field_id('ces_title')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ces_title')); ?>" 
                    value="<?php echo esc_attr($ces_title); ?>" />
            </p>
            <p> 
                <label>サブタイトル:</label><br>
                <input type="text" class="ces-sub" size="25" 
                    id="<?php echo  esc_attr($this->get_field_id('ces_sub')); ?>" 
                    name="<?php echo  esc_attr($this->get_field_name('ces_sub')); ?>" 
                    value="<?php echo esc_attr($ces_sub); ?>" />
            </p>
            <br>
            <div class="ce_wp-editor"> 
                <?php
                wp_editor(
                    wp_kses_post($ces_text),
                    esc_attr($this->get_field_id('ces_text')),
                    array(
                        'textarea_name' => esc_attr($this->get_field_name('ces_text')),
                        'textarea_rows' => 10,
                        'quicktags'     => true,
                        'media_buttons' => true,
                        'teeny'         => true,
                        'tinymce'       => [
                            'toolbar1' => 'bold,italic,link,unlink',
                            'toolbar2' => '',
                        ],
                        'wpautop'       => false,
                        'editor_class'  => 'widefat',
                        'editor_height' => 200,
                    )
                );
                ?>
            </div>
            </div>

            <hr style="margin-top:20px;">

            <p>
                <label>スライド枚数:</label><br>
                <input type="number" min="1" max="10"
                    id="<?php echo esc_attr($this->get_field_id('ces_num')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ces_num')); ?>" 
                    value="<?php echo esc_attr($ces_num); ?>" />
            </p>
            <div class="ces-accordion" style="margin:1em 0px;">
                <?php
                $ces_items = [];
                $ces_cont = ["img" => '',];
                for( $i = 0 ; $i < $ces_num ; $i++ ) {
                    $ces_items[$i] = $ces_cont;
                    $ces_items[$i]["img"] = !empty($instance['ces_img'.$i]) ? $instance['ces_img'.$i] : '';
                ?>
                    <a href="#" style="display:block; text-decoration:none; border-bottom:1px solid #2271b1; margin-top:1em;" class="toggle-settings">▼ スライド<?php echo esc_html($i+1); ?></a>
                    <div class="components-placeholder ces accordion-content" style="display:none;">
                        <p class="ce-img-selecter">
                            <img class="ce-image-preview" src="<?php echo esc_url($ces_items[$i]["img"]); ?>" 
                                style="max-width:100%; height:auto; <?php echo empty($ces_items[$i]["img"]) ? 'display:none;' : ''; ?>" />
                            <button class="button ce-select-image">背景画像を選択</button>
                            <button class="button ce-delete-image">背景画像を削除</button>
                            <input type="hidden" class="ce-img" 
                                id="<?php echo esc_attr($this->get_field_id('ces_img'.$i)); ?>" 
                                name="<?php echo esc_attr($this->get_field_name('ces_img'.$i)); ?>" 
                                value="<?php echo esc_attr($ces_items[$i]["img"]); ?>" />
                        </p>
                    </div>
                <?php } ?>
            </div>

            <hr style="margin-top:20px;">

            <div>
            <p> 
                <label>カスタムリンクテキスト:</label><br>
                <input type="text" placeholder="テキスト" 
                    id="<?php echo esc_attr($this->get_field_id('ces_link1_txt')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ces_link1_txt')); ?>" 
                    value="<?php echo esc_attr($ces_link1_txt); ?>" />
            </p>
            <p>
                <label>カスタムリンクテキストURL:</label><br>
                <input type="text" placeholder="https://example.com"  
                    id="<?php echo esc_attr($this->get_field_id('ces_link1_url')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('ces_link1_url')); ?>" 
                    value="<?php echo esc_url($ces_link1_url); ?>" />
            </p>
            <p> 
                <label>カスタムリンクテキストターゲット:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('ces_link1_target')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('ces_link1_target')); ?>">
                    <option value="_self" <?php selected($ces_link1_target, '_self'); ?>>現在のタブで開く</option>
                    <option value="_blank" <?php selected($ces_link1_target, '_blank'); ?>>新しいタブで開く</option>
                </select>
            </p>
            </div>
            <hr style="margin:25px 0px 0px 0px;">
            <div style="margin-bottom:15px;">
            <p> 
                <label>スタイル:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('ces_style')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('ces_style')); ?>">
                    <option value="s1" <?php selected($ces_style, 's1'); ?>>中央寄せ</option>
                    <option value="s2" <?php selected($ces_style, 's2'); ?>>左寄せ</option>
                    <option value="s3" <?php selected($ces_style, 's3'); ?>>右寄せ</option>
                </select>
            </p>
            </div>
        </div>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['ces_class'] = (!empty($new_instance['ces_class'])) ? sanitize_text_field($new_instance['ces_class']) : '';
        $instance['ces_num'] = (!empty($new_instance['ces_num']) && is_numeric($new_instance['ces_num'])) ? intval($new_instance['ces_num']) : 1;
        $instance['ces_title'] = (!empty($new_instance['ces_title'])) ? wp_kses_post($new_instance['ces_title']) : '';
        $instance['ces_sub'] = (!empty($new_instance['ces_sub'])) ? wp_kses_post($new_instance['ces_sub']) : '';
        $instance['ces_text'] = (!empty($new_instance['ces_text'])) ? wp_kses_post($new_instance['ces_text']) : '';
        $instance['ces_link1_txt'] = (!empty($new_instance['ces_link1_txt'])) ? wp_kses_post($new_instance['ces_link1_txt']) : '';
        $instance['ces_link1_url'] = (!empty($new_instance['ces_link1_url']) && $this->is_valid_internal_fragment($new_instance['ces_link1_url'])) ? esc_url_raw($new_instance['ces_link1_url']) : '';
        $instance['ces_link1_target'] = (!empty($new_instance['ces_link1_target'])) ? sanitize_text_field($new_instance['ces_link1_target']) : '';
        for( $i = 0 ; $i < $instance['ces_num'] ; $i++ ) {
            $instance['ces_img'.$i] = (!empty($new_instance['ces_img'.$i])) ? esc_url_raw($new_instance['ces_img'.$i]) : '';
        }
        $instance['ces_style'] = (!empty($new_instance['ces_style'])) ? sanitize_text_field($new_instance['ces_style']) : 's1';
        return $instance;
    }

    private function is_valid_internal_fragment($link) {
        if (strpos($link, '#') === 0) {
            return preg_match('/^#[a-zA-Z0-9\-_]*$/', $link);
        }
        if (preg_match('#^/[\w/-]*#\w+#', $link)) {
            return true;
        }
        $home_url = home_url();
        if (strpos($link, $home_url) === 0 && strpos($link, '#') !== false) {
            return true;
        }
        if (filter_var($link, FILTER_VALIDATE_URL)) {
            return true;
        }
        return false;
    }


}
add_action('admin_enqueue_scripts', function($hook) {
    if ($hook === 'widgets.php') {
        wp_enqueue_script('ce-slide', get_template_directory_uri() . '/widgets/slide/slide.js', array('jquery'), null, true);
        wp_localize_script('ce-slide', 'ceSlide', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('ce_slide_nonce'),
        ]);
    }
});
add_action('wp_ajax_ces_accordion', 'ces_accordion_callback');
function ces_accordion_callback() {
    check_ajax_referer('ce_slide_nonce', 'nonce');
    $parent_val = intval($_POST['parent_value']);
    $widget_id = sanitize_text_field($_POST['widget_id']);
    if(!empty($parent_val) && !empty($widget_id) && is_numeric($parent_val)) {
        $number = substr($widget_id, strrpos($widget_id, '-') + 1);
        global $wp_widget_factory;
        $widget_object = $wp_widget_factory->widgets['CoreEditSlider'];
        if (!$widget_object) {wp_send_json_error('Widget class not found');}
        $all_settings = $widget_object->get_settings();
        if (!isset($all_settings[$number])) {wp_send_json_error('No instance settings found');}
        $instance = $all_settings[$number];
        $ces_items = [];
        $ces_cont = [
            "img" => '',
        ];
        for( $i = 0 ; $i < $parent_val ; $i++ ) {
            $ces_items[$i] = $ces_cont;
            $ces_items[$i]["img"] = !empty($instance['ces_img'.$i]) ? $instance['ces_img'.$i] : '';
            ?>
            <a href="#" style="display:block; text-decoration:none; border-bottom:1px solid #2271b1; margin-top:1em;" class="toggle-settings">▼ スライド<?php echo esc_html($i+1); ?></a>
            <div class="components-placeholder ces accordion-content" style="display:none;">
                <p class="img-selecter">
                    <img class="image-preview" src="<?php echo esc_url($ces_items[$i]["img"]); ?>" 
                        style="max-width:100%; height:auto; <?php echo empty($ces_items[$i]["img"]) ? 'display:none;' : ''; ?>" />
                    <button class="button select-image">背景画像を選択</button>
                    <button class="button delete-image">背景画像を削除</button>
                    <input type="hidden" class="ces-img" 
                        id="<?php echo esc_attr($widget_object->get_field_id('ces_img'.$i)); ?>" 
                        name="<?php echo esc_attr($widget_object->get_field_name('ces_img'.$i)); ?>" 
                        value="<?php echo esc_attr($ces_items[$i]["img"]); ?>" />
                </p>
            </div>
            <?php
        }
    }
    wp_die();
}