<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * CoreEdit
 *
 * @author coreedit.jp
 * @copyright 2025 coreedit.jp
 * @license GPL-2.0-or-later
 */
?>
<?php
add_action( 'widgets_init', function () {
    register_widget( 'CoreEditTxt' );
});
class CoreEditTxt extends WP_Widget{

    public function __construct() {
        parent::__construct(
            'CoreEditTxt',
            'CoreEdit - テキスト',
            array('description' => 'テキストを出力します',
            'customize_selective_refresh' => false)
        );
    }

    public function widget($args, $instance) {
        $sidebar_id   = $args['id'];
        $cet_style = !empty($instance['cet_style']) ? $instance['cet_style'] : 's1';
        $widget_id = $this->id;
        $cet_items = [
            "class" => !empty($instance['cet_class']) ? $instance['cet_class'].' ' : '',
            "title_tag" => !empty($instance['cet_title_tag']) ? $instance['cet_title_tag'] : 'h2',
            "title" => !empty($instance['cet_title']) ? $instance['cet_title'] : '',
            "sub" => !empty($instance['cet_sub']) ? $instance['cet_sub'] : '',
            "text" => !empty($instance['cet_text']) ? $instance['cet_text'] : ''
        ];
        $cet_link1_txt = !empty($instance['cet_link1_txt']) ? $instance['cet_link1_txt'] : '';
        $cet_link1_url = !empty($instance['cet_link1_url']) ? $instance['cet_link1_url'] : '';
        $cet_link1_target = !empty($instance['cet_link1_target']) ? $instance['cet_link1_target'] : '_self';

        $use_stag = !empty($cet_items['title']) ? "section" : "div";
        $use_htag = $use_stag === "section" ? "header" : "div";

        if(empty($cet_items['img']) && empty($cet_items['title']) && empty($cet_items['sub']) && empty($cet_items['text']) ){return;}

        echo wp_kses_post(str_replace('class="', 'class="' .$cet_items['class'], $args['before_widget']));
        ?>
        <<?php echo $use_stag; ?> class="CoreEditTxt <?php echo esc_attr($widget_id).' '.esc_attr($cet_style); ?>">
            <div class="cet-inner widget-inner">
                <?php if(!empty($cet_items["title"]) || !empty($cet_items["sub"])) { ?>
                <<?php echo $use_htag; ?> class="cet-title">
                    <?php if(!empty($cet_items["title"])) { ?>
                    <<?php echo esc_attr($cet_items["title_tag"]); ?> class="widget-title"><?php echo wp_kses_post($cet_items["title"]); ?></<?php echo esc_attr($cet_items["title_tag"]); ?>>
                    <?php } ?>
                    <?php if(!empty($cet_items["sub"])) { ?>
                    <div><?php echo wp_kses_post($cet_items["sub"]); ?></div>
                    <?php } ?>
                </<?php echo $use_htag; ?>>
                <?php } ?>
                <?php if(!empty($cet_items["text"])) { ?>
                <div class="cet-text">
                    <?php echo wp_kses_post($cet_items["text"]); ?>
                </div>
                <?php } ?>
                <?php if(!empty($cet_link1_txt)) { ?>
                <div class="ce-links">
                    <a title="<?php echo esc_attr($cet_link1_txt); ?>" class="ce-link cet-link1" href="<?php echo esc_url($cet_link1_url); ?>"><?php echo esc_html($cet_link1_txt); ?></a>
                </div>
                <?php } ?>  
            </div>
        </<?php echo $use_stag; ?>>
        <?php
        echo wp_kses_post($args["after_widget"]);
    }

    public function form($instance) {
        $cet_items = [
            "class" => !empty($instance['cet_class']) ? $instance['cet_class'].' ' : '',
            "title_tag" => !empty($instance['cet_title_tag']) ? $instance['cet_title_tag'] : 'h2',
            "title" => !empty($instance['cet_title']) ? $instance['cet_title'] : '',
            "sub" => !empty($instance['cet_sub']) ? $instance['cet_sub'] : '',
            "text" => !empty($instance['cet_text']) ? $instance['cet_text'] : ''
        ];
        $cet_link1_txt = !empty($instance['cet_link1_txt']) ? $instance['cet_link1_txt'] : '';
        $cet_link1_url = !empty($instance['cet_link1_url']) ? $instance['cet_link1_url'] : '';
        $cet_link1_target = !empty($instance['cet_link1_target']) ? $instance['cet_link1_target'] : '_self';
        $cet_style = !empty($instance['cet_style']) ? $instance['cet_style'] : 's1';
        ?>
        <div class="components-placeholder ce">

            <div>
            <?php if('administrator' === wp_get_current_user()->roles[0]) { ?>
            <p>
                <label>クラス:</label><br>
                <input type="text" class="ceit-class" size="25" 
                    id="<?php echo esc_attr($this->get_field_id('cet_class')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('cet_class')); ?>" 
                    value="<?php echo esc_attr($cet_items["class"]); ?>" />
            </p>
            <p>
                <label>タグ:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('cet_title_tag')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('cet_title_tag')); ?>">
                    <option value="h1" <?php selected($cet_items["title_tag"], 'h1'); ?>>h1</option>
                    <option value="h2" <?php selected($cet_items["title_tag"], 'h2'); ?>>h2</option>
                    <option value="h3" <?php selected($cet_items["title_tag"], 'h3'); ?>>h3</option>
                    <option value="h4" <?php selected($cet_items["title_tag"], 'h4'); ?>>h4</option>
                    <option value="h5" <?php selected($cet_items["title_tag"], 'h5'); ?>>h5</option>
                </select>
            </p>
            <?php } ?>
            <p>
                <label>タイトル:</label><br>
                <input type="text" class="cet-title" size="25" 
                    id="<?php echo esc_attr($this->get_field_id('cet_title')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('cet_title')); ?>" 
                    value="<?php echo esc_attr($cet_items["title"]); ?>" />
            </p>
            <p> 
                <label>サブタイトル:</label><br>
                <input type="text" class="cet-sub" size="25" 
                    id="<?php echo esc_attr($this->get_field_id('cet_sub')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('cet_sub')); ?>" 
                    value="<?php echo esc_attr($cet_items["sub"]); ?>" />
            </p>
            <br>
            <div class="ce_wp-editor"> 
                <?php
                wp_editor(
                    wp_kses_post($cet_items["text"]),
                    esc_attr($this->get_field_id('cet_text')),
                    array(
                        'textarea_name' => esc_attr($this->get_field_name('cet_text')),
                        'textarea_rows' => 10,
                        'quicktags'     => true,
                        'media_buttons' => true,
                        'teeny'         => true,
                        'tinymce'       => [
                            'toolbar1' => 'bold,italic,link,unlink',
                            'toolbar2' => '',
                        ],
                        'wpautop'       => false,
                        'editor_class'  => 'widefat',
                        'editor_height' => 200,
                    )
                );
                ?>
            </div>
            <br>
            </div>

            <hr>

            <div>
            <p> 
                <label>カスタムリンクテキスト:</label><br>
                <input type="text" placeholder="テキスト" 
                    id="<?php echo esc_attr($this->get_field_id('cet_link1_txt')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('cet_link1_txt')); ?>" 
                    value="<?php echo esc_attr($cet_link1_txt); ?>" />
            </p>
            <p>
                <label>カスタムリンクURL:</label><br>
                <input type="text" placeholder="https://example.com"  
                    id="<?php echo esc_attr($this->get_field_id('cet_link1_url')); ?>" 
                    name="<?php echo esc_attr($this->get_field_name('cet_link1_url')); ?>" 
                    value="<?php echo esc_url($cet_link1_url); ?>" />
            </p>
            <p> 
                <label>カスタムリンクターゲット:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('cet_link1_target')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('cet_link1_target')); ?>">
                    <option value="_self" <?php selected($cet_link1_target, '_self'); ?>>現在のタブで開く</option>
                    <option value="_blank" <?php selected($cet_link1_target, '_blank'); ?>>新しいタブで開く</option>
                </select>
            </p>
            </div>

            <hr style="margin:25px 0px 0px 0px;">
            <div style="margin-bottom:15px;">
            <p> 
                <label>スタイル:</label><br>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('cet_style')); ?>"
                    name="<?php echo esc_attr($this->get_field_name('cet_style')); ?>">
                    <option value="s1" <?php selected($cet_style, 's1'); ?>>中央寄せ</option>
                    <option value="s2" <?php selected($cet_style, 's2'); ?>>左寄せ</option>
                    <option value="s3" <?php selected($cet_style, 's3'); ?>>右寄せ</option>
                </select>
            </p>
            </div>

        </div>
    <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['cet_class'] = (!empty($new_instance['cet_class'])) ? sanitize_text_field($new_instance['cet_class']) : '';
        $instance['cet_title_tag'] = (!empty($new_instance['cet_title_tag'])) ? sanitize_text_field($new_instance['cet_title_tag']) : '';
        $instance['cet_title'] = (!empty($new_instance['cet_title'])) ? wp_kses_post($new_instance['cet_title']) : '';
        $instance['cet_sub'] = (!empty($new_instance['cet_sub'])) ? wp_kses_post($new_instance['cet_sub']) : '';
        $instance['cet_text'] = (!empty($new_instance['cet_text'])) ? wp_kses_post($new_instance['cet_text']) : '';
        $instance['cet_link1_txt'] = (!empty($new_instance['cet_link1_txt'])) ? wp_kses_post($new_instance['cet_link1_txt']) : '';
        $instance['cet_link1_url'] = (!empty($new_instance['cet_link1_url']) && $this->is_valid_internal_fragment($new_instance['cet_link1_url'])) ? esc_url_raw($new_instance['cet_link1_url']) : '';
        $instance['cet_link1_target'] = (!empty($new_instance['cet_link1_target'])) ? sanitize_text_field($new_instance['cet_link1_target']) : '';
        $instance['cet_style'] = (!empty($new_instance['cet_style'])) ? sanitize_text_field($new_instance['cet_style']) : 's1';
        return $instance;
    }

    private function is_valid_internal_fragment($link) {
        if (strpos($link, '#') === 0) {
            return preg_match('/^#[a-zA-Z0-9\-_]*$/', $link);
        }
        if (preg_match('#^/[\w/-]*#\w+#', $link)) {
            return true;
        }
        $home_url = home_url();
        if (strpos($link, $home_url) === 0 && strpos($link, '#') !== false) {
            return true;
        }
        if (filter_var($link, FILTER_VALIDATE_URL)) {
            return true;
        }
        return false;
    }

}